/**************************************************************************************

	PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
	AUTHOR : See AUTHORS file for details

	This software is distributed under the terms of the GNU General Public License
	as specified in the COPYING file.

***************************************************************************************/

#include "ColorManager.hh"

namespace ColorManager
	{
	QColor color[MAX_COLORS];
	bool blur[MAX_COLORS];
	}

void ColorManager::init()
	{
	for (int i=0; i<=MAX_COLORS; i++)
		{
		color[i].setRgb(0,0,0);
		blur[i]=false;
		}

	// Generic Colors
	color[RED                        ].setRgb(255,0,0);
	color[GREEN                      ].setRgb(0,255,0);
	color[BLUE                       ].setRgb(0,0,255);
	color[YELLOW                     ].setRgb(255,255,0);
	color[ORANGE                     ].setRgb(255,200,0);
	color[CYAN                       ].setRgb(0,255,255);
	color[MAGENTA                    ].setRgb(255,0,255);
	color[LIGHT_RED                  ].setRgb(255,180,180);
	color[LIGHT_GREEN                ].setRgb(180,255,180);
	color[LIGHT_BLUE                 ].setRgb(180,180,255);
	color[LIGHT_YELLOW               ].setRgb(255,255,180);
	color[LIGHT_ORANGE               ].setRgb(255,200,100);
	color[LIGHT_CYAN                 ].setRgb(180,255,255);
	color[LIGHT_MAGENTA              ].setRgb(255,180,255);
	color[GRAY                       ].setRgb(180,180,180);
	color[WHITE                      ].setRgb(255,255,255);
	color[DARK_TEXT                  ].setRgb(0,0,0);
	color[MEDIUM_TEXT                ].setRgb(100,100,100);
	color[LIGHT_TEXT                 ].setRgb(200,200,200);

	// Track Colors
	color[TRACK_BG                   ].setRgb(60,  65, 73);
	color[TRACK_BG_ACTIVE            ].setRgb(190, 90, 90);
	color[TRACK_PANEL_BG             ].setRgb(190,205,210);
	color[TRACK_PANEL_BG_ACTIVE      ].setRgb(190,140, 90);

	// CLIP COLORS
	color[CLIP_BG                    ].setRgb(205,220,210);
	color[CLIP_BG_ACTIVE             ].setRgb(205,220,210);
	color[CLIP_BG_SELECTED           ].setRgb(101,111,171);
	color[CLIP_BG_MUTED              ].setRgb(40,40,40);
	color[CLIP_INFO_AREA_BG          ].setRgb(199,190,218);
	color[CLIP_INFO_AREA_BG_ACTIVE   ].setRgb(240,190,218);
	color[CLIP_PEAK_MICROVIEW        ].setRgb(100,0,20);
	color[CLIP_PEAK_MACROVIEW        ].setRgb(80,80,120);
	color[CLIP_PEAK_OVERLOADED_SAMPLE].setRgb(255,0,0);

	// Curve/Filters Colors
	color[CURVE_ACTIVE                   ].setRgb(255,50,50);
	color[CURVE_NONACTIVE                ].setRgb(110,100,130);
	color[FILTERCONTROLLER_ACTIVE        ].setRgb(255,50,50);
	color[FILTERCONTROLLER_NONACTIVE     ].setRgb(110,100,130);
	}


QColor ColorManager::get(int colorIndex)
	{
	if (blur[colorIndex])
		{
		QColor x;
		QColor c = color[colorIndex];
		int r = c.red();
		int g = c.green();
		int b = c.blue();
		float fr = (float) r / 255;
		float fg = (float) g / 255;
		float fb = (float) b / 255;
		int dr = (int)(50*fr);
		int dg = (int)(50*fg);
		int db = (int)(50*fb);
		r=90+dr;
		g=90+dg;
		b=120+db;
		x.setRgb(r,g,b);
		return x;
		}
	else
		return color[colorIndex];
	}

void ColorManager::set_blur(int index, bool stat)
	{
	blur[index]=stat;
	}

//eof
