/**************************************************************************************

	PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
	AUTHOR : See AUTHORS file for details

	This software is distributed under the terms of the GNU General Public License
	as specified in the COPYING file.

***************************************************************************************/

#ifndef COLORMANAGER_HH
#define COLORMANAGER_HH

#include <qcolor.h>

#define CM_COLOR(X) ColorManager::get(ColorManager::X)

namespace ColorManager
	{

		static const int MAX_COLORS = 37;
		static const bool BLUR = true;

		// Generic Colors
		static const int RED                    = 0;
		static const int GREEN                  = 1;
		static const int BLUE                   = 2;
		static const int YELLOW                 = 3;
		static const int ORANGE                 = 4;
		static const int CYAN                   = 5;
		static const int MAGENTA                = 6;
		static const int LIGHT_RED              = 7;
		static const int LIGHT_GREEN            = 8;
		static const int LIGHT_BLUE             = 9;
		static const int LIGHT_YELLOW           = 10;
		static const int LIGHT_ORANGE           = 11;
		static const int LIGHT_CYAN             = 12;
		static const int LIGHT_MAGENTA          = 13;
		static const int GRAY                   = 14;
		static const int WHITE                  = 15;
		static const int DARK_TEXT              = 16;
		static const int MEDIUM_TEXT            = 17;
		static const int LIGHT_TEXT             = 18;

		// Track Specific Colors
		static const int TRACK_BG               = 19;
		static const int TRACK_BG_ACTIVE        = 20;
		static const int TRACK_PANEL_BG         = 21;
		static const int TRACK_PANEL_BG_ACTIVE  = 22;

		// Clip Specific Colors
		static const int CLIP_BG                     = 23;
		static const int CLIP_BG_ACTIVE              = 24;
		static const int CLIP_BG_SELECTED            = 25;
		static const int CLIP_BG_MUTED               = 26;
		static const int CLIP_INFO_AREA_BG           = 27;
		static const int CLIP_INFO_AREA_BG_ACTIVE    = 28;
		static const int CLIP_PEAK_MICROVIEW         = 29;
		static const int CLIP_PEAK_MACROVIEW         = 30;
		static const int CLIP_PEAK_OVERLOADED_SAMPLE = 32;

		//Curves/FilterController colors
		static const int CURVE_ACTIVE = 33;
		static const int CURVE_NONACTIVE = 34;
		static const int FILTERCONTROLLER_ACTIVE = 35;
		static const int FILTERCONTROLLER_NONACTIVE = 36;

		void init();
		QColor get(int colorIndex);
		void set_blur(int index, bool stat);

	};


#endif

