/**************************************************************************************

        PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/


#ifndef FILEBROWSER_HH
#define FILEBROWSER_HH

#include <qiconview.h>
#include <qlistview.h>
#include <qdir.h>
#include <qprogressbar.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qtoolbutton.h>
#include <qwidget.h>
#include <qdragobject.h>
#include <qevent.h>
#include <qlayout.h>
#include <qtimer.h>
#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qevent.h>
#include <qsplitter.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qheader.h>
#include <qapplication.h>
#include <qpainter.h>
#include <qlineedit.h>
#include <qpopupmenu.h>
#include <qhbox.h>
#include <qcursor.h>



class FileBrowser;
class DirectoryView;
class QtFileIconViewItem;



class QtFileIconDrag : public QIconDrag
        {
        Q_OBJECT

        public:
                QtFileIconDrag( QWidget * dragSource, const char* name = 0 );

                const char* format( int i ) const;
                QByteArray encodedData( const char* mime ) const;
                static bool canDecode( QMimeSource* e );
                void append( const QIconDragItem &item, const QRect &pr, const QRect &tr, const QString &url );

        private:
                QStringList urls;

        };



class QtFileIconView : public QIconView
        {
        Q_OBJECT

        public:
                QtFileIconView( FileBrowser* pAssocFileBrowser, const QString &dir, QWidget *parent = 0, const char *name = 0 );

        enum ViewMode { Large, Small };

                void setViewMode( ViewMode m );
                ViewMode viewMode() const { return vm; }
                void setOpenItem( QtFileIconViewItem *i ) { openItem = i; }
                FileBrowser* assocFileBrowser;

        public slots:
                void setDirectory( const QString &dir );
                void setDirectory( const QDir &dir );
                void newDirectory();
                QDir currentDir();

        signals:
                void directoryChanged( const QString & );
                void startReadDir( int dirs );
                void readNextDir();
                void readDirDone();
                void enableUp();
                void disableUp();
                void enableMkdir();
                void disableMkdir();

        protected slots:
                void itemDoubleClicked( QIconViewItem *i );
                void slotDropped( QDropEvent *e, const QValueList<QIconDragItem> & );

                void viewLarge();
                void viewSmall();
                void viewBottom();
                void viewRight();
                void flowEast();
                void flowSouth();
                void itemTextTruncate();
                void itemTextWordWrap();
                void sortAscending();
                void sortDescending();
                void arrangeItemsInGrid() { QIconView::arrangeItemsInGrid( TRUE ); }
                void slotRightPressed( QIconViewItem *item );
                void openFolder();

        protected:

                void readDir( const QDir &dir );
                virtual QDragObject *dragObject();

        virtual void keyPressEvent( QKeyEvent *e );

                QDir viewDir;
                int newFolderNum;
                QSize sz;
                QPixmap pix;
                ViewMode vm;
                QtFileIconViewItem *openItem;
        };


class QtFileIconViewItem : public QIconViewItem
{
        friend class QtFileIconView;

        public:
                enum ItemType {
                        File = 0,
                        Dir,
                        Link
                };

                QtFileIconViewItem( FileBrowser* pAssocFileBrowser, QtFileIconView *parent, QFileInfo *fi );

                virtual ~QtFileIconViewItem();

                ItemType type() const { return itemType; }
                QString filename() const { return itemFileName; }

                virtual bool acceptDrop( const QMimeSource *e ) const;

                virtual void setText( const QString &text );
                virtual QPixmap *pixmap() const;

                virtual void dragEntered();
                virtual void dragLeft();

                void viewModeChanged( QtFileIconView::ViewMode m );
                void paintItem( QPainter *p, const QColorGroup &cg );

        protected:
                FileBrowser* assocFileBrowser;
                virtual void dropped( QDropEvent *e, const QValueList<QIconDragItem> & );

                QString itemFileName;
                QFileInfo *itemFileInfo;
                ItemType itemType;
                bool checkSetText;
                QTimer timer;
                QtFileIconView::ViewMode vm;
        };



class FileItem : QListViewItem
        {
        public:
        FileItem( QListViewItem *parent, const QString &s1, const QString &s2 )
                : QListViewItem( parent, s1, s2 ), pix( 0 ) {}

        const QPixmap *pixmap( int i ) const;
        void setPixmap( QPixmap *p );

        private:
        QPixmap *pix;

        };

class Directory : public QListViewItem
        {
        public:
        Directory( QListView * parent, const QString& filename );
        Directory( Directory * parent, const QString& filename, const QString &col2 )
                : QListViewItem( parent, filename, col2 ), pix( 0 ) {}
        Directory( Directory * parent, const QString& filename );

        QString text( int column ) const;

        QString fullName();

        void setOpen( bool );
        void setup();

        const QPixmap *pixmap( int i ) const;
        void setPixmap( QPixmap *p );

        private:
                QFile f;
                Directory * p;
                bool readable;
                bool showDirsOnly;
                QPixmap *pix;

        };

class DirectoryView : public QListView
        {
        Q_OBJECT

        public:
                DirectoryView( QWidget *parent = 0, const char *name = 0, bool sdo = FALSE );
                bool showDirsOnly() { return dirsOnly; }

        public slots:
                void setDir( const QString & );

        signals:
                void folderSelected( const QString & );

        protected slots:
                void slotFolderSelected( QListViewItem * );
                void openFolder();

        protected:
                void contentsDragEnterEvent( QDragEnterEvent *e );
                void contentsDragMoveEvent( QDragMoveEvent *e );
                void contentsDragLeaveEvent( QDragLeaveEvent *e );
                void contentsDropEvent( QDropEvent *e );
                void contentsMouseMoveEvent( QMouseEvent *e );
                void contentsMousePressEvent( QMouseEvent *e );
                void contentsMouseReleaseEvent( QMouseEvent *e );

        private:
                QString fullPath(QListViewItem* item);
                bool dirsOnly;
                QListViewItem *oldCurrent;
                QListViewItem *dropItem;
                QTimer* autoopen_timer;
                QPoint presspos;
                bool mousePressed;

        };


class FileBrowser : public QWidget
        {
        Q_OBJECT

        public:
                FileBrowser(QWidget * parent = 0);

                QtFileIconView *fileView() { return fileview; }
                DirectoryView *dirList() { return dirlist; }
                QLineEdit* filename;
                QComboBox *pathCombo;

        protected:
                void setPathCombo(const QString &dir);

                QtFileIconView *fileview;
                DirectoryView *dirlist;
                QProgressBar *progress;
                QLabel *label;
                QPushButton *upButton, *mkdirButton;
                QBoxLayout *mainBox;

        protected slots:
                void directoryChanged( const QString & );
                void slotStartReadDir( int dirs );
                void slotReadNextDir();
                void slotReadDirDone();
                void cdUp();
                void newFolder();
                void changePath( const QString &path );
                void enableUp();
                void disableUp();
                void enableMkdir();
                void disableMkdir();

        };



#endif
