/**************************************************************************************

	PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
	AUTHOR : See AUTHORS file for details

	This software is distributed under the terms of the GNU General Public License
	as specified in the COPYING file.

***************************************************************************************/
#include <mustux.h>
#include "GlobalPropertiesDialog.hh"
#include "GlobalProperties.hh"

/*
*  Constructs a GlobalProperties which is a child of 'parent', with the
*  name 'name' and widget flags set to 'f'
*
*  The dialog will by default be modeless, unless you set 'modal' to
*  TRUE to construct a modal dialog.
*/
GlobalPropertiesDialog::GlobalPropertiesDialog( Interface* pParentInterface) : QDialog( (QWidget*) 0 ,"")
	{
	PENTERCONS;
	parentInterface = pParentInterface;
	resize( 500, 380 );
	setCaption( "Global Properties Window" );
	QPushButton* buttonApply = new QPushButton( this );
	buttonApply->setGeometry( QRect( 50, 320, 230, 30 ) );
	buttonApply->setText( "APPLY, SAVE AND CLOSE" );
	QPushButton* buttonClose = new QPushButton( this );
	buttonClose->setGeometry( QRect( 300, 320, 100, 30 ) );
	buttonClose->setText( "CLOSE");
	QTabWidget* tabWidget1 = new QTabWidget( this);
	tabWidget1->setGeometry( QRect( 0, 0, 490, 300 ) );


	// HARDWARE STUFF
	QWidget* tab1 = new QWidget( tabWidget1 );

	QWidget* layoutContainer1 = new QWidget( tab1  );
	layoutContainer1->setGeometry( QRect( 60, 60, 320, 25 ) );
	QHBoxLayout* layout1 = new QHBoxLayout( layoutContainer1 );
	layout1->setSpacing( 6 );
	layout1->setMargin( 0 );
	wAlsaControllerRadioGroup = new QButtonGroup( "Alsa Controller" , layoutContainer1);
	wAlsaControllerRadioGroup->setGeometry( QRect( 20, 50, 300, 40 ) );
	layout1->addWidget( wAlsaControllerRadioGroup );
	QHBoxLayout* layout11 = new QHBoxLayout( wAlsaControllerRadioGroup );
	QRadioButton* radioButton1 = new QRadioButton( wAlsaControllerRadioGroup);
	radioButton1->setText("Use plughw controller");
	radioButton1->setGeometry( QRect( 30, 60, 100, 20 ) );
	layout11->addWidget( radioButton1 );
	QRadioButton* radioButton2 = new QRadioButton( wAlsaControllerRadioGroup);
	radioButton2->setText("Use hw controller");
	radioButton2->setGeometry( QRect( 150, 60, 100, 20 ) );
	layout11->addWidget( radioButton2 );
	QString t = GlobalProperties::get("USE_PLUGHW");
	if (t=="YES")
		radioButton1->setChecked (true);
	else
		radioButton2->setChecked (true);


	QWidget* layoutContainer2 = new QWidget( tab1 );
	layoutContainer2->setGeometry( QRect( 60, 120, 330, 25 ) );
	QHBoxLayout* layout2 = new QHBoxLayout( layoutContainer2 );
	layout2->setSpacing( 6 );
	layout2->setMargin( 0 );
	QLabel* textLabel2 = new QLabel( layoutContainer2 );
	textLabel2->setText( "Slice Width Factor");
	layout2->addWidget( textLabel2 );
	wSliceWidthFactor = new QSpinBox( layoutContainer2 );
	QToolTip::add(  wSliceWidthFactor, tr( "How big will be the fragments of audio will be buff" ) );
	int swf = GlobalProperties::get_int("SLICE_WIDTH_FACTOR");
	PMESG("Setting GlobalPropertiesDialog slice width factor text box to %d",swf);
	wSliceWidthFactor->setValue(swf);
	layout2->addWidget( wSliceWidthFactor );

	QWidget* layoutContainer3 = new QWidget( tab1 );
	layoutContainer3->setGeometry( QRect( 60, 170, 400, 25 ) );
	QHBoxLayout* layout3 = new QHBoxLayout( layoutContainer3 );
	layout3->setSpacing( 6 );
	layout3->setMargin( 0 );
	QLabel* textLabel3 = new QLabel( layoutContainer3 );
	textLabel3->setText( "Default Sample Rate (When Creating Songs)");
	layout3->addWidget( textLabel3 );
	wDefaultSampleRate = new QComboBox( FALSE, layoutContainer3 );
	wDefaultSampleRate->insertItem( "22050" );
	wDefaultSampleRate->insertItem( "32000" );
	wDefaultSampleRate->insertItem( "44100" );
	wDefaultSampleRate->insertItem( "48000" );
	wDefaultSampleRate->insertItem( "96000" );
	wDefaultSampleRate->setCurrentItem( 2);// FOR LATERGlobalProperties::get_int("DEFAULT_SAMPLE_RATE");
	layout3->addWidget( wDefaultSampleRate );
	//QToolTip::add(  wDefaultSampleRate, tr( "This will NOT change the current song's properties. It will affect ONLY NEW projects/songs" ) );

	QWidget* layoutContainer4 = new QWidget( tab1 );
	layoutContainer4->setGeometry( QRect( 60, 220, 400, 25 ) );
	QHBoxLayout* layout4 = new QHBoxLayout( layoutContainer4 );
	layout4->setSpacing( 6 );
	layout4->setMargin( 0 );
	QLabel* textLabel4 = new QLabel( layoutContainer4 );
	textLabel4->setText( "Default Bit Depth (When Creating Songs)" );
	//QToolTip::add(  wDefaultBitDepth, tr( "This will NOT change the current song's properties. It will affect ONLY NEW projects/songs" ) );
	layout4->addWidget( textLabel4 );
	wDefaultBitDepth = new QComboBox( FALSE, layoutContainer4  );
	wDefaultBitDepth->insertItem( "16"  );
	wDefaultBitDepth->setCurrentItem(0); // FOR LATERGlobalProperties::get_int("DEFAULT_BIT_DEPTH");
	layout4->addWidget( wDefaultBitDepth );



	// JMB
	QWidget* tab2 = new QWidget( tabWidget1 );
	QLabel* TextLabel5 = new QLabel( tab2 );
	TextLabel5->setGeometry( QRect( 30, 30, 200, 20 ) );
	TextLabel5->setText( "Jmb Clear Time" );
	wJmbClearTime = new QSpinBox( tab2 );
	wJmbClearTime->setGeometry( QRect( 250, 30, 100, 25 ) );
	wJmbClearTime->setMaxValue(5000);
	wJmbClearTime->setMinValue(500);
	wJmbClearTime->setValue(GlobalProperties::get_int("JMB_CLEAR_TIME"));
	//QToolTip::add(  wJmbClearTime, tr( "How long (in ms) the LCD will show a message until it cleans" ) );

	QLabel* TextLabel51 = new QLabel( tab2 );
	TextLabel51->setGeometry( QRect( 30, 80, 200, 20 ) );
	TextLabel51->setText( "Double Fact Timeout (ms)" );
	wJmbDoubleFactInterval = new QSpinBox( tab2 );
	wJmbDoubleFactInterval->setGeometry( QRect( 250, 80, 100, 25 ) );
	wJmbDoubleFactInterval->setMinValue(50);
	wJmbDoubleFactInterval->setMaxValue(1000);
	wJmbDoubleFactInterval->setValue(GlobalProperties::get_int("JMB_DOUBLE_FACT_TIMEOUT"));
	//QToolTip::add(  wJmbDoubleFactInterval, tr( "How long (in ms) will pass between two facts (actions like <<>> or <>[])" ) );

	QLabel* TextLabel52 = new QLabel( tab2 );
	TextLabel52->setGeometry( QRect( 30, 130, 200, 20 ) );
	TextLabel52->setText( "Hold Timeout (ms)" );
	wJmbHoldSensitivenessFactor = new QSpinBox( tab2 );
	wJmbHoldSensitivenessFactor->setGeometry( QRect( 250, 130, 100, 25 ) );
	wJmbHoldSensitivenessFactor->setMinValue(140);
	wJmbHoldSensitivenessFactor->setMaxValue(5000);
	wJmbHoldSensitivenessFactor->setValue(GlobalProperties::get_int("JMB_HOLD_TIMEOUT"));
	//QToolTip::add(  wJmbHoldSensitivenessFactor, tr( "How long (in ms) a fact must be hold to be considered a hold." ) );

	QPushButton* PushButton5 = new QPushButton( tab2 );
	PushButton5->setGeometry( QRect( 350, 270, 180, 30 ) );
	PushButton5->setText( "View JMB Map" );



	// EXTERNAL PROGRAMS
	QWidget* tab3 = new QWidget( tabWidget1 );

	QWidget* layoutContainer6 = new QWidget( tab3 );
	layoutContainer6->setGeometry( QRect( 60, 60, 420, 32 ) );
	QHBoxLayout* Layout6 = new QHBoxLayout( layoutContainer6 );
	Layout6->setSpacing( 6 );
	Layout6->setMargin( 0 );
	QLabel* TextLabel6 = new QLabel( layoutContainer6 );
	TextLabel6->setText( "Mp3 decode command" );
	Layout6->addWidget( TextLabel6 );
	wMp3DecodeCommand= new QLineEdit( layoutContainer6 );
	wMp3DecodeCommand->setText( GlobalProperties::get("MP3_DECODE_COMMAND"));
	Layout6->addWidget( wMp3DecodeCommand);


	QWidget* layoutContainer8 = new QWidget( tab3 );
	layoutContainer8->setGeometry( QRect( 60, 120, 420, 32 ) );
	QHBoxLayout* Layout8 = new QHBoxLayout( layoutContainer8 );
	Layout8->setSpacing( 6 );
	Layout8->setMargin( 0 );
	QLabel* TextLabel8 = new QLabel( layoutContainer8 );
	TextLabel8->setText( "Ogg encode command" );
	Layout8->addWidget( TextLabel8 );
	wOggEncodeCommand= new QLineEdit( layoutContainer8 );
	wOggEncodeCommand->setText( tr( GlobalProperties::get("OGG_ENCODE_COMMAND")) );
	Layout8->addWidget( wOggEncodeCommand);


	QWidget* layoutContainer9 = new QWidget( tab3 );
	layoutContainer9->setGeometry( QRect( 60, 180, 420, 32 ) );
	QHBoxLayout* Layout9 = new QHBoxLayout( layoutContainer9 );
	Layout9->setSpacing( 6 );
	Layout9->setMargin( 0 );
	QLabel* TextLabel9 = new QLabel( layoutContainer9 );
	TextLabel9->setText( "Ogg decode command" );
	Layout9->addWidget( TextLabel9 );
	wOggDecodeCommand= new QLineEdit( layoutContainer9 );
	wOggDecodeCommand->setText( tr( GlobalProperties::get("OGG_DECODE_COMMAND") ) );
	Layout9->addWidget( wOggDecodeCommand);
	QLabel* TextLabel91 = new QLabel( tab3 );
	TextLabel91->setGeometry( QRect( 48, 255, 470, 40 ) );
	TextLabel91->setText( "Note: \"%if\"  == input file  / \"%of\" == output file" );



	//  MTA
	QWidget* tab4 = new QWidget( tabWidget1 );
	QLabel* textLabel10 = new QLabel( tab4 );
	textLabel10->setGeometry( QRect( 41, 31, 190, 30 ) );
	textLabel10->setText( "Default Number of Tracks" );
	wDefaultNumTracks = new QSpinBox( tab4 );
	wDefaultNumTracks->setGeometry( QRect( 250, 30, 97, 23 ) );
	wDefaultNumTracks->setMinValue(1);
	wDefaultNumTracks->setMaxValue(16);
	wDefaultNumTracks->setValue(GlobalProperties::get_int("DEFAULT_NUM_TRACKS"));

	QLabel* textLabel101 = new QLabel( tab4 );
	textLabel101->setGeometry( QRect( 38, 85, 190, 30 ) );
	textLabel101->setText( "Default H Zoom Level"  );
	wDefaultHZoomLevel = new QComboBox( FALSE, tab4 );
	wDefaultHZoomLevel->insertItem( "1:1"  );
	wDefaultHZoomLevel->insertItem( "1:2"  );
	wDefaultHZoomLevel->insertItem( "1:4"  );
	wDefaultHZoomLevel->insertItem( "1:6"  );
	wDefaultHZoomLevel->insertItem( "1:8"  );
	wDefaultHZoomLevel->insertItem( "1:12" );
	wDefaultHZoomLevel->insertItem( "1:16" );
	wDefaultHZoomLevel->insertItem( "1:20"  );
	wDefaultHZoomLevel->insertItem( "1:24" );
	wDefaultHZoomLevel->insertItem( "1:32" );
	wDefaultHZoomLevel->insertItem( "1:48" );
	wDefaultHZoomLevel->insertItem( "1:64" );
	wDefaultHZoomLevel->insertItem( "1:96" );
	wDefaultHZoomLevel->insertItem( "1:128" );
	wDefaultHZoomLevel->insertItem( "1:192" );
	wDefaultHZoomLevel->insertItem( "1:256" );
	wDefaultHZoomLevel->insertItem( "1:384" );
	wDefaultHZoomLevel->insertItem( "1:512" );
	wDefaultHZoomLevel->insertItem( "1:768"  );
	wDefaultHZoomLevel->insertItem( "1:1024" );
	wDefaultHZoomLevel->insertItem( "1:1536" );
	wDefaultHZoomLevel->insertItem( "1:2048" );
	wDefaultHZoomLevel->insertItem( "1:3072" );
	wDefaultHZoomLevel->insertItem( "1:4096" );
	wDefaultHZoomLevel->insertItem( "1:6144" );
	wDefaultHZoomLevel->insertItem( "1:8192" );
	wDefaultHZoomLevel->insertItem( "1:12288" );
	wDefaultHZoomLevel->insertItem( "1:16384" );
	wDefaultHZoomLevel->insertItem( "1:24576" );
	wDefaultHZoomLevel->insertItem( "1:32768" );
	wDefaultHZoomLevel->insertItem( "1:65536" );

	wDefaultHZoomLevel->setCurrentItem( GlobalProperties::get_int("HZOOM_LEVEL"));
	wDefaultHZoomLevel->setGeometry( QRect( 250, 90, 88, 22 ) );

	tabWidget1->insertTab( tab1, "Hardware"  );
	tabWidget1->insertTab( tab2, "JMB" );
	tabWidget1->insertTab( tab3, "External Programs" );
	tabWidget1->insertTab( tab4, "MTA" );

	connect( buttonApply, SIGNAL(clicked()), this, SLOT(apply()) );
	connect( buttonClose, SIGNAL(clicked()), this, SLOT(close()) );

	PEXITCONS;
	}

/*
*  Destroys the object and frees any allocated resources
*/
GlobalPropertiesDialog::~GlobalPropertiesDialog()
	{
	PENTERDES;
	// no need to delete child widgets, Qt does it all for us
	PEXITDES;
	}

void GlobalPropertiesDialog::apply()
	{
	PENTER;
	PMESG("Applying properties...");
	GlobalProperties::set("SLICE_WIDTH_FACTOR",(char*) wSliceWidthFactor->text().ascii());
	GlobalProperties::set("JMB_CLEAR_TIME",(char*) wJmbClearTime->text().ascii());
	GlobalProperties::set("JMB_HOLD_TIMEOUT",(char*) wJmbHoldSensitivenessFactor->text().ascii());
	GlobalProperties::set("JMB_DOUBLE_FACT_TIMEOUT",(char*) wJmbDoubleFactInterval->text().ascii());
	GlobalProperties::set("DEFAULT_NUM_TRACKS",(char*) wDefaultNumTracks->text().ascii());
	GlobalProperties::set("HZOOM_LEVEL",wDefaultHZoomLevel->currentItem());
	GlobalProperties::set("DEFAULT_SAMPLE_RATE",(char*) wDefaultSampleRate->currentText().ascii());
	GlobalProperties::set("DEFAULT_BIT_DEPTH",(char*) wDefaultBitDepth->currentText().ascii());
	GlobalProperties::set("AUDIO_MAPPER_FPS","20"); // IMPROVE ME
	GlobalProperties::set("USE_PLUGHW",(char*) (wAlsaControllerRadioGroup->find(0)->isOn()?"YES":"NO"));
	GlobalProperties::set("USE_EXTERNAL_OGG_DECODER","YES"); // IMPROVE ME
	GlobalProperties::set("USE_EXTERNAL_OGG_ENCODER","YES"); // IMPROVE ME
	GlobalProperties::set("MP3_DECODE_COMMAND",(char*) wMp3DecodeCommand->text().ascii());
	GlobalProperties::set("OGG_DECODE_COMMAND",(char*) wOggDecodeCommand->text().ascii());
	GlobalProperties::set("OGG_ENCODE_COMMAND",(char*) wOggEncodeCommand->text().ascii());
	GlobalProperties::save();
	parentInterface->update_properties();
	hide();
	PEXIT;
	}



void GlobalPropertiesDialog::close()
	{
	PENTER;
	hide();
	PEXIT;
	}

//eof

