/**************************************************************************************

        PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/
#ifndef GLOBALPROPERTIESWINDOW_HH
#define GLOBALPROPERTIESWINDOW_HH

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QComboBox;
class QLabel;
class QLineEdit;
class QPushButton;
class QRadioButton;
class QSpinBox;
class QTabWidget;
class Interface;
class QButtonGroup;
#include <qdialog.h>

#define DICT_SIZE 20

class GlobalPropertiesDialog : public QDialog
        {
        Q_OBJECT

        public:
                GlobalPropertiesDialog( Interface* pParentInterface);
                ~GlobalPropertiesDialog();

        protected:
                Interface* parentInterface;
                QComboBox *wDefaultSampleRate,
                          *wDefaultHZoomLevel,
                          *wDefaultBitDepth;
                QSpinBox  *wSliceWidthFactor,
                          *wJmbClearTime,
                          *wJmbHoldSensitivenessFactor,
                          *wJmbDoubleFactInterval,
                          *wDefaultNumTracks;
                QLineEdit *wMp3DecodeCommand,
                          *wOggDecodeCommand,
                          *wOggEncodeCommand;
                QButtonGroup *wAlsaControllerRadioGroup;



        public slots:
                void apply();
                void close();

        };

#include <qcombobox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qspinbox.h>
#include <qtabwidget.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qdialog.h>
#include <qasciidict.h>
#include <qwhatsthis.h>
#include "Interface.hh"

#endif
