/**************************************************************************************

	PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
	AUTHOR : See AUTHORS file for details

	This software is distributed under the terms of the GNU General Public License
	as specified in the COPYING file.

***************************************************************************************/
#ifndef INTERFACE_HH
#define INTERFACE_HH


#include <qlayout.h>
#include <qimage.h>
#include <qlabel.h>
#include <mustux.h>

class SplashScreen;
class Help;
class GlobalPropertiesDialog;
class ProjectManager;
class Project;
class Song;
class BusMonitor;


class Interface : public MustuxInterface
	{
	Q_OBJECT

	public :

		static const int MINIMUM_INTERFACE_WIDTH = 600;
		static const int MINIMUM_INTERFACE_HEIGHT = 300;

		Interface(QWidget *parent);
		~Interface();

		int new_project();
		int import_audio(const QString &filename);
		int process_jmb_action( MustuxJogMouseBoardMessage* jmbMesg ); // implements

		void update_properties();
		void set_current_project(Project *proj);
		void show_project_info();
		void info(QString message);
		void info(QString message, int line);
		void busmonitor_dock();
		void busmonitor_undock();
		bool is_busmonitor_docked();

		Project* get_current_project();
		MustuxLcd* get_default_lcd();
		BusMonitor* get_bus_monitor();
		ProjectManager* get_project_manager();

		MustuxLcd* infoLcd;
		MustuxDrawable* busBox;
		MustuxDrawable* dataBox;
		BusMonitor* busMonitor;
		QWidget* busMonitorWindow;
		MustuxTuner* tuner;
		Help* helpWindow;
		ProjectManager* projectManager;
		GlobalPropertiesDialog* globalPropertiesDialog;
		SplashScreen* splashScreen;

	protected:
		void resizeEvent(QResizeEvent* e);
		bool isBusMonitorDocked;


	private:
		QTimer* statusBarTimer;
		QVBoxLayout *mainVBoxLayout;
		QHBoxLayout* lay;
		QWidget* topSplitter;
		QLabel* ramUsage;
		QLabel* snapStatus;
		QLabel* freeTime;
		QLabel* diskUsage;
		QLabel* diskSpace;

	public slots :
		void help();
		void quick_help();
		void show_jmb_map();
		void about_protux();
		void show_splash_screen();
		void hide_splash_screen();
		void update_system_resources();
	};

#include "SplashScreen.hh"
#include "Help.hh"
#include "GlobalProperties.hh"
#include "GlobalPropertiesDialog.hh"

#include "ProjectManager.hh"
#include "Project.hh"
#include "Song.hh"
#include "BusMonitor.hh"

#endif


// eof
