/**************************************************************************************

        PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/

#ifndef PROJECT_HH
#define PROJECT_HH

#include <qstring.h>
#include <qwidget.h>
#include <qwidgetstack.h>
#include <qprogressbar.h>

#define MAX_SONGS_PER_PROJECT 30

#include <mustux.h>

class Interface;
class Song;
class Spectrogram;
class ProjectManager;
class BusMonitor;

class Project : public QWidget
        {
        Q_OBJECT
        public :
                        Project(QString pProjectToLoadTitle, Interface* pAssocInterface);
                        ~Project();

                        void set_title(QString pTitle);
                        void set_engineer(QString pEngineer);

                        QString get_title();
                        int get_number_of_songs();
                        QString get_engineer();

                        int create(int pNumSongs);
                        int save();
                        int load();
			int load_songs();
                        int rename();
                        int render();
                        int import_audio(QString filename,QProgressBar *monitorProgressBar = 0 );
                        void  show_info();
			bool any_other_song_going();
			bool has_changed();
			bool is_some_peak_building();

                        Song* add_song();
                        Song* add_song(int rate, int bitDepth);

                        int set_current_song(Song* pSong);
                        void set_current_song(int id);
                        int get_current_song_id();
                        Song* get_current_song();
			Song* get_song(int id);

                        QString get_capture_dir();
                        QString get_root_dir();

                        Interface* get_parent_interface();
                        void set_output_spectrogram(Spectrogram* pSpectrogram);
			int update_properties();

                        MustuxLcd* get_default_lcd();
			BusMonitor* get_bus_monitor();

			void recreate();

        private :
                        Spectrogram* spectrogram;
                        QWidgetStack* songsContainer;
                        Interface* parentInterface;
                        QString title;
                        QString userDir;
                        QString projsDir;
                        QString rootDir;
                        int numSongs;
                        int currentSongId;
                        QString engineer;
                        Song* song[MAX_SONGS_PER_PROJECT];

                        friend class ProjectManager;

        protected slots:
                        void changed();
        };

#include "Interface.hh"
#include "Song.hh"
#include "ProjectManager.hh"
#include "BusMonitor.hh"

#endif
