/**************************************************************************************

	PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
	AUTHOR : See AUTHORS file for details

	This software is distributed under the terms of the GNU General Public License
	as specified in the COPYING file.

***************************************************************************************/
#ifndef PROJECTMANAGER_HH
#define PROJECTMANAGER_HH


#include <qlineedit.h>
#include <qtabwidget.h>
#include <qwidget.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qlistview.h>
#include <qgroupbox.h>
#include <qslider.h>
#include <qprogressbar.h>
#include <qcheckbox.h>
#include <qdialog.h>
#include <qmessagebox.h>

class Project;
class FileBrowser;
class Interface;

class ProjectManager : public QDialog
	{
	Q_OBJECT

	public:
		ProjectManager( Interface* pParentInterface, const char* name = 0 );
		~ProjectManager();

		int create_new_project(QString projectName, int numSong);
		int load_project(QString projectName);

		bool project_is_current(QString title);
		bool projectExists(QString title);
		/*
		const char* get_curr_project_name();
		int get_curr_project_num_songs();
		*/


		Project* currentProject;
		FileBrowser* fileBrowser;	//Was a private attribute. Does it make sense it is public now?
		QListView* audioListView;	//same for this one
		bool isPlaying;

		QPushButton* btnFilePlay;
		QPushButton* btnSourcePlay;

		float gain;
		int whichTabActive;

		static void* th_preListen(void* arg);

	public slots:
		virtual void listAlbumProject_projectSelected();
		virtual void btnImportNow_clicked();
		virtual void btnSaveProject_clicked();
		virtual void btnLoadProject_clicked();
		virtual void btnCopyToProject_clicked();
		virtual void btnCreateProject_clicked();
		virtual void btnDeleteProject_clicked();
		virtual void btnSaveSongAs_clicked();
		virtual void btnSaveSongCopyAs_clicked();
		virtual void btnNewSong_clicked();
		virtual void listSongs_songSelected();
		virtual void btnSaveSong_clicked();
		virtual void btnRemoveSongFromProject_clicked();
		virtual void btnDeleteSong_clicked();
		virtual void delete_source();
		virtual void btnRemoveUnusedSources_clicked();
		virtual void btnRemoveAllClips_clicked();
		virtual void btnExportSource_clicked();
		virtual void btnSourcePlay_clicked();
		virtual void sliderSource_moved();
		virtual void sliderFile_moved();
		virtual void btnFilePlay_clicked();
		virtual void btnAddFileAsSource_clicked();
		virtual void btnAddSourceCDA_clicked();
		virtual void btnImportNowCDA_clicked();
		virtual void btnCDAPlay_clicked();
		virtual void btnRender_clicked();
		virtual void btnMaster_clicked();
		virtual void btnBurnCD_clicked();
		virtual void audioListView_itemRenamed( QListViewItem *, int );
		virtual void audioListView_spacePressed( QListViewItem * );
		virtual void audioListView_returnPressed( QListViewItem * );
		virtual void audioListView_onItem( QListViewItem * );
		virtual void audioListView_collapsed( QListViewItem * );
		virtual void audioListView_expanded( QListViewItem * );
		virtual void tab_changed();


		void show();
		void update();


	private :
		void set_current_project(Project* pProject);
		void update_audio_sources_list();
		void update_projects_list();
		void update_song_list();
		int remove_recursively(QString pName);
		int copy_recursively(QString pNameFrom, QString pNameTo);

		Interface *parentInterface;

		QTabWidget* mainTabPane;
		QWidget* tab;
		QLabel* lblAlbumTitle;
		QLineEdit* fieldAlbumTitle;
		QLabel* lblNOfSongs;
		QLineEdit* fieldNOfSongs;
		QLabel* lblStatus;
		QComboBox* cmbStatus;
		QLabel* lblTotalDur;
		QLabel* lblEngineer;
		QLineEdit* fieldEngineer;

		QPushButton* btnRender;
		QPushButton* btnMaster;
		QPushButton* btnBurnCD;
		QPushButton* btnCreateProject;
		QPushButton* btnLoadProject;
		QPushButton* btnSaveProject;
		QPushButton* btnCopyToProject;
		QLineEdit* fieldSaveProjAs;
		QPushButton* btnDeleteProject;
		QListView* listAlbumProjects;
		QWidget* tab_2;
		QLabel* lblMasterGain;
		QLineEdit* fieldMasterGain;
		QLabel* lblNumTracks;
		QLineEdit* fieldNumTracks;
		QLabel* lblSongDur;
		QLineEdit* fieldSongDur;
		QLabel* lblArtist;
		QLineEdit* fieldArtists;
		QLabel* TextLabel2;
		QComboBox* cmbSongStatus;
		QComboBox* cmbPreListenBus;

		QPushButton* btnSaveSong;
		QPushButton* btnRemoveSongFromProject;
		QPushButton* btnDeleteSong;
		QPushButton* btnSaveSongAs;
		QPushButton* btn;
		QPushButton* btnNewSong;
		QLabel* lblOr;
		QLineEdit* fieldCopyTo;
		QListView* listSongs;
		QWidget* tab_3;
		QPushButton* btnDeleteSource;
		QPushButton* btnRemoveUnusedSources;
		QPushButton* btnRemoveAllClips;
		QPushButton* btnExportSource;
		QGroupBox* grpPreListenSource;
		QLineEdit* fieldAudioSourceInfo;
		QLabel* lblSourceSpectro;
		QLabel* lblDSPVol1;
		QLabel* volumeSource;
		QSlider* sliderSource;
		QCheckBox* checkSourceInfo;
		QCheckBox* checkSourceSpectro;

		QWidget* tab_4;
		QLabel* lblFileBrowser_2;
		QGroupBox* grpPreListenFile;
		QLabel* lblDSPVol2;
		QLabel* volumeFile;
		QSlider* sliderFile;
		QCheckBox* checkFileInfo;
		QCheckBox* checkFileSpectro;
		QLabel* lblFileSpectro;
		QLineEdit* fieldFileInfo;
		QGroupBox* grpImportFile;
		QLabel* lblFileDestSong;
		QLineEdit* fieldFileDestSong;
		QLabel* lblFileDestTrack;
		QLineEdit* fieldFileDestTrack;
		QLabel* lblFileDestPos;
		QLineEdit* fieldFileDestPos;
		QPushButton* btnAddFileAsSource;
		QPushButton* btnImportFileNow;
		QProgressBar* pbarFileImport;
		QCheckBox* checkFileFakeImport;
		QWidget* tab_5;
		QLabel* lblCDBrowser_2;
		QGroupBox* grpImportCDA;
		QLabel* lblDestSongCDA;
		QLineEdit* fieldDestSongCDA;
		QLabel* lblDestTrackCDA;
		QLineEdit* fieldDestTrackCDA;
		QLabel* lblDestPosCDA;
		QLineEdit* fieldDestPosCDA;
		QPushButton* btnAddSourceCDA;
		QPushButton* btnImportNowCDA;
		QProgressBar* pbarImportCDA;
		QCheckBox* checkFakeImportCDA;
		QGroupBox* grpPreListenCDA;
		QLabel* lblCDAVol;
		QSlider* sliderCDA;
		QPushButton* btnCDAPlay;
	protected:
		QVBoxLayout* AudioSourcesViewerLayout;
	};


#include "FileBrowser.hh"
#include "Project.hh"


#endif
