/**************************************************************************************

        PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/
#include "Protux.hh"

#include <stdio.h>
#include <dirent.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <qmessagebox.h>
#include <stdlib.h>


Protux::Protux(int argc, char **argv ) : MustuxApplication ( argc, argv )
        {
        PENTERCONS;
        GlobalProperties::init();
        MustuxAudioDeviceMapper::init(); 
        check_dirs();
        interface = new Interface((QWidget*) 0);
        setMainWidget( interface );
        interface->show();
        PEXITCONS;
        }

Protux::~Protux()
        {
        PENTERDES;
        delete interface;
        GlobalProperties::finish();
	PEXITDES;
        }


void Protux::check_dirs()
        {
        PENTER2;
        //QString currDir = QDir::absPath(".");
        QString user_path = QString(getenv("HOME")) + "/";
        QString projects_path = user_path + "protuxprojects";

        //chdir(user_path);
        DIR* t = opendir((const char*) projects_path.latin1());
        if (t==NULL)
                {
                PMESG("Creating %s ", (const char*)projects_path.latin1() );
                mkdir((const char*) projects_path.latin1(), S_IREAD | S_IWRITE | S_IEXEC);
                QMessageBox::warning( 0, "Protux", "No protuxprojects directory under your home dir.\n"
                                         "I created one for you in "  + projects_path );
                }
        else closedir(t);
        //chdir ((const char*) projects_path.latin1());
        PEXIT2;
        }


// eof

