/**************************************************************************************

        PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/

#include "SongPropertiesDialog.hh"

SongPropertiesDialog::SongPropertiesDialog( Song* pAssocSong )
    : QDialog( (QWidget*) 0, "", TRUE, 0 )
        {
        assocSong = pAssocSong;
        resize( 519, 190 );
        setCaption("Song Properties" );

        label2 = new QLabel( this);
        label2->setGeometry( QRect( 10, 90, 97, 25 ) );
        label2->setText("Bit Depth");

        buttonOK = new QPushButton( this);
        buttonOK->setGeometry( QRect( 140, 140, 140, 35 ) );
        buttonOK->setText("APPLY AND SAVE");

        buttonCancel = new QPushButton( this);
        buttonCancel->setGeometry( QRect( 290, 140, 120, 35 ) );
        buttonCancel->setText("CLOSE <ESC>");

        label1 = new QLabel( this);
        label1->setGeometry( QRect( 10, 50, 111, 25 ) );
        label1->setText( "Sample Rate" );

        comboBitDepth = new QComboBox( FALSE, this );
        comboBitDepth->insertItem( "16" );
        comboBitDepth->setGeometry( QRect( 140, 90, 190, 32 ) );

        comboSampleRate = new QComboBox( FALSE, this);
        comboSampleRate->insertItem( "22050"  );
        comboSampleRate->insertItem( "32000"  );
        comboSampleRate->insertItem( "44100"  );
        comboSampleRate->insertItem( "48000"  );
        comboSampleRate->insertItem( "96000"  );

        comboSampleRate->setGeometry( QRect( 140, 50, 190, 32 ) );

        label4 = new QLabel( this);
        label4->setGeometry( QRect( 340, 40, 160, 90 ) );
        label4->setText( "Note : Protux only\n supports 16 bits\n audio by now" );

        connect( buttonOK, SIGNAL(clicked()), this, SLOT(apply()) );
        connect( buttonCancel, SIGNAL(clicked()), this, SLOT(ok()) );
        }

SongPropertiesDialog::~SongPropertiesDialog()
        {
        }


int SongPropertiesDialog::get_rate()
        {
        QString s = comboSampleRate->currentText();
        return s.toInt();
        }

int SongPropertiesDialog::get_bit_depth()
        {
        QString s = comboBitDepth->currentText();
        return s.toInt();
        }

void SongPropertiesDialog::apply()
        {
        PENTER;
        assocSong->change_settings(get_rate(),get_bit_depth());
        PEXIT;
        }



void SongPropertiesDialog::ok()
        {
        PENTER;
        this->hide();
        PEXIT;
        }



void SongPropertiesDialog::update()
        {
        PENTER;
        int rate;
        int bitDepth;
        rate=assocSong->get_rate();
        bitDepth=assocSong->get_bit_depth();
        PMESG("Updating Song Properties Dialog with rate=%d bitDepth=%d",rate,bitDepth);

        if (rate==22050)
                comboSampleRate->setCurrentItem(0);
        else if (rate==32000)
                comboSampleRate->setCurrentItem(1);
        else if (rate==44100)
                comboSampleRate->setCurrentItem(2);
        else if (rate==48000)
                comboSampleRate->setCurrentItem(3);
        else if (rate==96000)
                comboSampleRate->setCurrentItem(4);
        else
                comboSampleRate->setCurrentItem(2);
        PEXIT;
        }

//eof
