/**************************************************************************************

        PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/
#ifndef SPECTROGRAM_HH
#define SPECTROGRAM_HH

#include <mustux.h>
#include <mustux.h>


#include "qtimer.h"

class Spectrogram : public MustuxDrawable
        {
        Q_OBJECT
        public :
                Spectrogram(int pWidth, int pHeight , QWidget *parent, const char* pName);
                ~Spectrogram();

                void set_data(short* data);
                void activate();
                void deactivate();

        protected:
                
                static const int NBANDS;
                static const int bandIndex[32];

                void set_scale_factor(float f);
                QTimer* updateTimer;
                float scaleFactor;
                short *buf;
                int fftSize;
                MustuxFft* mustuxFft;

                float currentLevel[40];

        public slots :
                void update();
        };

#endif



