/**************************************************************************************

	PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
	AUTHOR : See AUTHORS file for details

	This software is distributed under the terms of the GNU General Public License
	as specified in the COPYING file.

***************************************************************************************/
#ifndef TRACK_HH
#define TRACK_HH

#include <mustux.h>
#include <qstring.h>

class Audio;
class AudioClip;
class Mixer;
class Song;
class TrackPanel;
class FilterChain;

class Track : public MustuxDrawableRegion
	{
	Q_OBJECT
	public :
		Track(Song* pParentSong, int pID, QString pName, int pBaseY, int pHeight);
		~Track();

		static const int INITIAL_HEIGHT = 100;
		static const int MINIMUM_HEIGHT = 70;

		void set_assoc_track_panel(TrackPanel* pAssocTrackPanel);
		void recreate();
		void recreate_mta();	//Added By Remon
		void activate();
		void deactivate();
		void update();
		int play(long long startpoint);
		int cleanup_buffers();
		int draw();
		void clear();
		void clear_clips();
		bool is_pointed();
		void set_blur(bool stat);

		AudioClip* add_clip(AudioClip* clip, long long newInsertBlock);
		AudioClip* add_clip(Audio* audioSource, long long insertBlock, bool isTake = false);
		AudioClip* add_clip(Audio* audioSource, long long insertBlock, long long sourceFirstblock, long long lenght, bool isTake = false);
		AudioClip* get_clip_under(long long blockPos);
		AudioClip* get_clip_after(long long blockPos);
		AudioClip* get_clip_before(long long blockPos);

		int split_clip(long long splitPoint);
		int delete_clip(AudioClip* clip, bool permanently = 0);

		int arm();
		int disarm();
		void toggle_active();

		QString get_schema();
		void set_schema(QString schema);
		QString get_name();
		Song* get_parent_song();

		int get_bus_in();
		void set_bus_in(int b);
		int get_bus_out();
		void set_bus_out(int b);
		int get_which_channels();
		void set_which_channels(int wc);

		void vzoom_in(int newBaseY);
		void vzoom_out(int newBaseY);

		bool is_muted();
		bool is_solo();
		bool is_active();
		bool armed();

		float get_gain();
		float get_pan();
		void set_gain(float pGain);
		void set_pan(float pPan);

		int get_baseX();
		int get_baseY();
		int get_width();
		int get_height();

		int set_baseY(int b);
		int set_height(int h);


		int start_recording_clip();
		int abort_recording_clip();
		int feed_recording_clip(char* data, int size);
		void draw_recording_peaks(char* recBuf, int bufSize, int blockSize, int channels, long long startPos);
		int finish_recording_clip();
		int accept_recorded_clip();
		void discard_recorded_clip();  //WAS int abort..() changed by Remon

		// should be protected ...
		AudioClip* clipList;
		int get_total_clips();

		int get_mouse_x();
		int get_mouse_y(); // return the real Y
		int get_mouse_relative_y();// return the Y em relation to tracks base Y

		bool visible();

		int real_baseY();

		TrackPanel* assocTrackPanel;
		Song* parentSong;
		FilterChain* filterChain;
		Mixer* mixer;

	private :


		float inputLevelMax[2]; // review me
		float inputLevel[2]; // review me

		float gain;
		float pan;

		int baseY;
		int height;

		int ID;
		QString name;

		int busIn;
		int busOut;
		int whichChannels;

		bool isActive;
		bool isSolo;
		bool isMuted;
		bool isArmed;

		QString recordingAudioFilename;
		Audio* recordingAudio;
		AudioClip* lastRecordedClip;
		MustuxAudioFileFormat* recordingAudioFile;
		long long recordingAudioStartPos;
		long long recordingAudioPos;
		int recordingBufferSize;
		char * recordingBuffer;
		QTimer* updateTimer;


		friend class Song;
		friend class AudioClip;
		friend class Curve;
		friend class TrackPanel;
		friend class FilterChain;
		friend class Mixer;


	public slots :
		void update_recording_clip();

	};

#include "Song.hh"
#include "Audio.hh"
#include "AudioClip.hh"
#include "Mixer.hh"
#include "TrackPanel.hh"
#include "filters/Filters.hh"
#include "filters/FilterController.hh"

#endif

