/**************************************************************************************

        PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/
#include <qcolor.h>
#include <mustux.h>
#include "TrackPanel.hh"
#include "ColorManager.hh"
#include "Song.hh"



TrackPanel::TrackPanel(Track* pAssocTrack )
        : MustuxDrawableRegion( pAssocTrack->get_parent_song()->get_tracks_area() )
        {
        PENTERCONS;
        assocTrack = pAssocTrack;
        drawArea = assocTrack->get_parent_song()->get_track_panels_area();
        sid.setNum(assocTrack->ID+1);
	gainValue = assocTrack->get_gain();
	panValue = assocTrack->get_pan();
	sgain.setNum(gainValue,'f',1);
        span.setNum(panValue,'f',1);
        PEXITCONS;
        }


TrackPanel::~TrackPanel()
        {
        PENTERDES;
        PEXITDES;
        }


void TrackPanel::recreate()
        {
        clear();
        draw();
        update();
        }


void TrackPanel::update()
        {
        drawArea->update(0,assocTrack->real_baseY(),drawArea->width(),assocTrack->height);
        }



void TrackPanel::clear()
        {
        drawArea->painter->fillRect(0, assocTrack->real_baseY(), drawArea->width() , assocTrack->height, CM_COLOR(TRACK_PANEL_BG));
        }



void TrackPanel::draw()
        {
        int baseY = assocTrack->real_baseY();
        int height = assocTrack->get_height();

        QPainter* p = drawArea->painter;

        if (assocTrack->isActive)
                p->fillRect(0,baseY,drawArea->width(),20,QColor(240,140,150));
        else
                p->fillRect(0,baseY,drawArea->width(),20,QColor(170,180,190));

        p->setFont( QFont( "Helvetica", 10, QFont::Bold) );
        p->setPen(QColor(0,0,225));
        p->drawText(4,baseY+14, sid);
        p->setPen(QColor(255,255,255));
        p->drawText(5,baseY+15, sid);

        p->setFont( QFont( "Helvetica", 8, QFont::Bold) );
        p->drawText(15,baseY+15, assocTrack->name);

	set_gain();
	set_pan();

        const int MUTE_BUTTON_X = 90;
        const int MUTE_BUTTON_Y = baseY+4;
        const int MUTE_BUTTON_W = 19;
        const int MUTE_BUTTON_H = 15;

        const int SOLO_BUTTON_X = 115;
        const int SOLO_BUTTON_Y = baseY+4;
        const int SOLO_BUTTON_W = 19;
        const int SOLO_BUTTON_H = 15;

        const int REC_BUTTON_X = 140;
        const int REC_BUTTON_Y = baseY+4;
        const int REC_BUTTON_W = 19;
        const int REC_BUTTON_H = 15;

        p->setFont( QFont( "Helvetica", 6) );
        if (assocTrack->is_muted())
                {
                p->setPen(CM_COLOR(DARK_TEXT));
                p->fillRect(MUTE_BUTTON_X,MUTE_BUTTON_Y,MUTE_BUTTON_W,MUTE_BUTTON_H, CM_COLOR(GREEN));
                p->drawRect(MUTE_BUTTON_X,MUTE_BUTTON_Y,MUTE_BUTTON_W,MUTE_BUTTON_H);
                p->drawText(MUTE_BUTTON_X + 2, MUTE_BUTTON_Y + 10, "MU");
                }
        else
                {
                p->setPen(CM_COLOR(DARK_TEXT));
                p->fillRect(MUTE_BUTTON_X, MUTE_BUTTON_Y, MUTE_BUTTON_W, MUTE_BUTTON_H, CM_COLOR(TRACK_PANEL_BG));
                p->drawRect(MUTE_BUTTON_X, MUTE_BUTTON_Y, MUTE_BUTTON_W, MUTE_BUTTON_H);
                p->drawText(MUTE_BUTTON_X + 2, MUTE_BUTTON_Y + 10, "MU");
                }

        if (assocTrack->is_solo())
                {
                p->setPen(CM_COLOR(DARK_TEXT));
                p->fillRect(SOLO_BUTTON_X,SOLO_BUTTON_Y,SOLO_BUTTON_W,SOLO_BUTTON_H, CM_COLOR(GREEN));
                p->drawRect(SOLO_BUTTON_X,SOLO_BUTTON_Y,SOLO_BUTTON_W,SOLO_BUTTON_H);
                p->drawText(SOLO_BUTTON_X + 2, SOLO_BUTTON_Y + 10, "SO");
                }
        else
                {
                p->setPen(CM_COLOR(DARK_TEXT));
                p->fillRect(SOLO_BUTTON_X, SOLO_BUTTON_Y, SOLO_BUTTON_W, SOLO_BUTTON_H, CM_COLOR(TRACK_PANEL_BG));
                p->drawRect(SOLO_BUTTON_X, SOLO_BUTTON_Y, SOLO_BUTTON_W, SOLO_BUTTON_H);
                p->drawText(SOLO_BUTTON_X + 2, SOLO_BUTTON_Y + 10, "SO");
                }

        if (assocTrack->armed())
                {
                p->setPen(CM_COLOR(DARK_TEXT));
                p->fillRect(REC_BUTTON_X,REC_BUTTON_Y,REC_BUTTON_W,REC_BUTTON_H, CM_COLOR(RED));
                p->drawRect(REC_BUTTON_X,REC_BUTTON_Y,REC_BUTTON_W,REC_BUTTON_H);
                p->drawText(REC_BUTTON_X + 2, REC_BUTTON_Y + 10, "RE");
                }
        else
                {
                p->setPen(CM_COLOR(DARK_TEXT));
                p->fillRect(REC_BUTTON_X, REC_BUTTON_Y, REC_BUTTON_W, REC_BUTTON_H, CM_COLOR(TRACK_PANEL_BG));
                p->drawRect(REC_BUTTON_X, REC_BUTTON_Y, REC_BUTTON_W, REC_BUTTON_H);
                p->drawText(REC_BUTTON_X + 2, REC_BUTTON_Y + 10, "RE");
                }

        int inRoute = assocTrack->get_bus_in();
        int outRoute = assocTrack->get_bus_out();
        p->setFont( QFont( "Helvetica", 6) );
        QString sir = MustuxAudioDeviceMapper::get_bus_in_name(inRoute);

        if (assocTrack->get_which_channels()==MustuxAudioDeviceMapper::MONO)
                sir.append(" [MO]");
        else if (assocTrack->get_which_channels()==MustuxAudioDeviceMapper::STEREO)
                sir.append(" [LR]");
        else if (assocTrack->get_which_channels()==MustuxAudioDeviceMapper::ONLY_LEFT_CHANNEL)
                sir.append(" [L]");
        else
                sir.append(" [R]");

        QString sor = MustuxAudioDeviceMapper::get_bus_out_name(outRoute);

        p->fillRect(10,baseY + 57,10,10,QColor(255,0,0));
        p->setPen(Qt::black);
        p->drawRect(10,baseY + 57,10,10);
        p->drawText(30, baseY + 65, sir);

        p->fillRect(10,baseY + 72,10,10,QColor(0,255,0));
        p->setPen(Qt::black);
        p->drawRect(10,baseY + 72,10,10);
        p->drawText(30, baseY + 80, sor);
        }


bool TrackPanel::is_pointed()
        {
        int baseY = assocTrack->real_baseY();
        int height = assocTrack->get_height();
        int x = drawArea->mapFromGlobal(QCursor::pos()).x();
        int y = drawArea->mapFromGlobal(QCursor::pos()).y();
        bool b = ((x>=0) && (x<=0+drawArea->width()) && (y>=baseY) && (y<=baseY+height));
        return b ;
        }


void TrackPanel::set_gain()
	{
        int baseY = assocTrack->real_baseY();
        QPainter* p = drawArea->painter;
        int sliderWidth=drawArea->width()-75;
        int sliderx=10;
	float v;
	int y;
	QString s;
        p->setPen(QColor(0,0,25));
        p->setFont( QFont( "Helvetica", 6) );
        y = baseY+30;

	//first clear the gain-area
        p->fillRect(0, y-10, drawArea->width() , 10, CM_COLOR(TRACK_PANEL_BG));
        p->drawText(sliderx, y, "GAIN");
	gainValue = assocTrack->get_gain();
	//only set span when really necessary! setNum() is a very expensive call
	int jogMode = assocTrack->get_parent_song()->jogMode;
	if (jogMode == Song::JOG_GAIN || jogMode == Song::JOG_GAIN_AND_PAN || jogMode == Song::JOG_NONE)
		sgain.setNum(gainValue,'f',1);
        s = ( gainValue > 0 ? QString("+") + sgain :  sgain );
        v = gainValue/25;
        p->fillRect(sliderx+30,y-8,sliderWidth,10,QColor(200,200,240));
        p->drawRect(sliderx+30,y-8,sliderWidth,10);
        float nv = (v+1)/2;
        int cr = (v>=0?55+(int)(200*nv):0);
        int cb = (v>=0?0:55+abs((int)(200*nv)));
        p->fillRect(sliderx+30,y-8,(int)(nv*sliderWidth),10,QColor(cr,0,cb));
        p->drawText(sliderx+30+sliderWidth+10,y, s);
	}


void TrackPanel::set_pan()
	{
        int baseY = assocTrack->real_baseY();
        QPainter* p = drawArea->painter;
        int sliderWidth=drawArea->width()-75;
        int sliderx=10;
	float v;
	int y;
	QString s;
        y=baseY+45;

	//first clear the pan-area
        p->fillRect(0, y-10, drawArea->width() , 10, CM_COLOR(TRACK_PANEL_BG));
	p->drawText(sliderx, y, "PAN");
	panValue = assocTrack->get_pan();
        v = panValue;
	//only set span when really necessary! setNum() is a very expensive call
	int jogMode = assocTrack->get_parent_song()->jogMode;
	if (jogMode == Song::JOG_PAN || jogMode == Song::JOG_GAIN_AND_PAN || jogMode == Song::JOG_NONE)
		span.setNum(v,'f',1);
        s = ( v > 0 ? QString("+") + span :  span );
        p->fillRect(sliderx+30,y-8,sliderWidth,10,QColor(200,200,240));
        p->drawRect(sliderx+30,y-8,sliderWidth,10);
        int pm=sliderx+30+sliderWidth/2;
        int z = abs((int)(v*(sliderWidth/2)));
        int c = abs((int)(255*v));
        if (v>=0)
                p->fillRect(pm,y-7,z,8,  QColor(c,0,0));
        else
                p->fillRect(pm-z,y-7,z,8,QColor(c,0,0));
        p->drawText(sliderx+30+sliderWidth+10,y, s);
	}

// eof

