/**************************************************************************************

	PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
	AUTHOR : See AUTHORS file for details

	This software is distributed under the terms of the GNU General Public License
	as specified in the COPYING file.

***************************************************************************************/

#include "AudioFilter.hh"
#include <mustux.h>
#include <string.h>


AudioFilter::AudioFilter(int pSampleRate,int pChannels)
	{
	PENTERCONS;
	sampleRate = pSampleRate;
	channels = pChannels;
	isBypassed=false;
	tailBuffer = (char*) 0;
	tailSize=0;
	PEXITCONS;
	}

AudioFilter::~AudioFilter()
	{
	PENTERDES;
	if (tailBuffer)
		delete tailBuffer;
	PEXITDES;
	}


void AudioFilter::set_preview_quality(float value)
	{
	previewQuality = value;
	}

void AudioFilter::set_wet_out(float value)
	{
	wetOut = value;
	}


void AudioFilter::set_dry_out(float value)
	{
	dryOut = value;
	}

void AudioFilter::set_pre_gain(float value)
	{
	preGain = value;
	}

void AudioFilter::set_pos_gain(float value)
	{
	posGain = value;
	}

float AudioFilter::get_preview_quality()
	{
	return previewQuality;
	}

float AudioFilter::get_wet_out()
	{
	return wetOut;
	}

float AudioFilter::get_dry_out()
	{
	return dryOut;
	}

float AudioFilter::get_pre_gain()
	{
	return preGain;
	}

float AudioFilter::get_pos_gain()
	{
	return posGain;
	}


int AudioFilter::load_data( char* pAudioFragment, int pFragmentSize )
	{
	PERROR("Oops... you should not calling virtual methods...");
	return -1;
	}

int AudioFilter::prepare()
	{
	PERROR("Oops... you should not calling virtual methods...");
	return -1;
	}

int AudioFilter::process()
	{
	PERROR("Oops... you should not calling virtual methods...");
	return -1;
	}


void AudioFilter::init_tail(int secs)
	{
	tailSize = sampleRate*channels*secs;
	PMESG("Initializing Tail Buffer : size %d=",tailSize);
	tailBuffer=new char[tailSize];
	bzero(tailBuffer,tailSize);
	}


void AudioFilter::push_tail(int size)
	{
	// push (shift) the tail left;
	memcpy(tailBuffer, tailBuffer+size, tailSize-size);
	bzero(tailBuffer+(tailSize-size),size);
	}

int AudioFilter::cleanup()
	{
	bzero(tailBuffer,tailSize);
	return 1;
	}

// eof
