/**************************************************************************************

	PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
	AUTHOR : See AUTHORS file for details

	This software is distributed under the terms of the GNU General Public License
	as specified in the COPYING file.

***************************************************************************************/
#include "Curve.hh"
#include <stdlib.h>
#include "../ColorManager.hh"

Curve::Curve(FilterController* pAssocController, QString pType)
	{
	PENTERCONS;
	assocFilterController = pAssocController;
	type = pType;
	PMESG("Creating Curve : %s ", (const char*) pType.latin1());
	active=false;
	PMESG("Adding root node [0:0.00]");
	// Initial node, always added.
	head = new CurveNode( this, 0, 0.0);
	head->prev=(CurveNode*)0;
	head->next=(CurveNode*)0;
	currentNode = head;
	PEXITCONS;
	}


Curve::~Curve()
	{
	PENTERDES;
	CurveNode* n = head;
	while (n)
		{
		CurveNode* n2 = n->next;
		delete n;
		n=n2;
		}
	PEXITDES;
	}

void Curve::activate()
	{
	active=true;
	}

void Curve::deactivate()
	{
	active=false;
	}

CurveNode* Curve::add_node(long long p, float v)
	{
	PENTER2;
	CurveNode* no;
	if (p==0)
		{
		no = head;
		no->set_value(v);
		}
	else
		{
		no = new CurveNode( this, p, v);
		add_node(no);
		}
	PEXIT2;
	return no;
	}


void Curve::add_node(CurveNode* node)
	{
	PENTER2;
	if (!head)
		{
		head = node;
		node->prev=0;
		node->next=0;
		}
	else
		{
		CurveNode* n1 = head;
		CurveNode* n2 = head;
		while (n1 && (n1->pos < node->pos))
			{
			n2=n1;
			n1=n1->next;
			}
		if (!n1)
			{
			n2->next=node;
			node->prev=n2;
			node->next=0;
			}
		else
			{
			node->prev=n2;
			node->next=n1;
			n2->next=node;
			n1->prev=node;
			}
		}
	currentNode = node;

	/* ONLY FOR DEBUG PURPOSES
	printf("Node List is now :\n");
	CurveNode* no = head;
	while (no)
		{
		printf("\t\t%ld=%2.2f\n",(long)no->pos,no->value);
		no=no->next;
		}
	*/
	PEXIT2;
	}




CurveNode* Curve::get_nearest_node(long long pos)
	{
	PENTER4;
	if (pos<0)
		{
		PEXIT4;
		return head;
		}
	CurveNode* nno = (CurveNode*) 0;
	CurveNode* no = head;
	while (no)
		{
		if (no->next)
			{
			if (abs(pos - no->pos) < abs(pos - no->next->pos))
				{
				nno=no;
				break;
				}
			}
		else
			nno=no;
		no=no->next;
		}
	return nno;
	PEXIT4;
	}




void Curve::delete_node(CurveNode* node)
	{
	PENTER;
	PEXIT;
	}


float Curve::get_value_at(long long pos)
// THIS FUNCTION NEEDS HUGE OPTIMIZATION !! It finds the nearest node everytime it needs to get the value. for
// playback this is a waste of CPU. it could "follow" the playback and keep  updating the nearest node for playback cursor during the playback.
	{
	PENTER4;
	float value=0.0;
	CurveNode* cn = get_nearest_node(pos);
	if (!cn) // MAYBE THIS CHECK IS NOT NECESSARY
		{
		PEXIT4;
		return 0.0;
		}
	if ( (!cn->next) && (pos >= cn->pos)) // after last node, all points use the last node value
		{
		PEXIT4;
		return cn->value;
		}
	CurveNode* cl;
	CurveNode* cr;
	if ( pos >= cn->pos)
		{
		cl = cn;
		cr = cn->next;
		}
	else
		{
		cl = cn->prev;
		cr = cn;
		}
	long long dx = pos - cl->pos;
	long long dd = cr->pos - cl->pos;
	float dv = cr->value - cl->value;
	double qd = (double)dx/(double)dd;
	float dy = dv*(float)qd;
	value = cl->value + dy;
	PEXIT4;
	return value;
	}

void Curve::show()
	{
	PENTER3;
	if (!head)
		{
		PEXIT3;
		return;
		}

	Track* parentTrack = assocFilterController->parentChain->assocTrack;

	int baseY = parentTrack->get_baseY();
	int half = parentTrack->get_height()/2;
	QPainter* p = parentTrack->get_painter();

	CurveNode* n = head;
	int yc = baseY + half;

	int lastx = 0;
	int lasty = yc;

	//if ( n->pos < firstBlock ) continue; FOR LATER
	//if ( n->pos > lastBlock ) break; FOR LATER
	Song* parentSong = parentTrack->parentSong;
	if (active)
		p->setPen(CM_COLOR(CURVE_ACTIVE));
	else
		p->setPen(CM_COLOR(CURVE_NONACTIVE));
	while (n)
		{
		int x = parentSong->block_to_xpos(n->pos);
		int y = yc + (int) (-1*n->value * half / 100 );
		p->drawLine(lastx, lasty, x, y);
		lastx=x;
		lasty=y;
		n=n->next;
		}
	p->drawLine(lastx, lasty, parentTrack->get_width(), lasty);

	n = head;
	while (n)
		{
		n->draw();
		n=n->next;
		}
	PEXIT3;
	}


void Curve::hide()
	{
	PENTER;
	PEXIT;
	}


void Curve::highlight(int pXpos)
	{
	PENTER;
	PEXIT;
	}



CurveNode* Curve::get_current_curve_node()
	{
	return currentNode;
	}

QString Curve::get_type()
	{
	return type;
	}

QString Curve::get_schema()
	{
	QString schema="";
	CurveNode* n = head;
	while (n)
		{
		QString sp; sp.setNum((double)n->pos,'g',10);
		QString sv; sv.setNum(n->value);
		schema=schema+"                 <node pos="+sp+" value="+sv+" />\n";
		n=n->next;
		}
	return schema;
	}
//eof

