/**************************************************************************************

        PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/

#ifndef FILTERCHAIN_HH
#define FILTERCHAIN_HH

#include <mustux.h>
#define MAX_FILTER_CONTROLLERS 10


class Track;
class FilterController;

class FilterChain
        {
        public:
                FilterChain(Track* pAssocTrack);
                ~FilterChain();

		FilterController* add_filter_controller(QString filterName);
                void select_controller(bool isBeginning);

                int remove_controller(int index = -1);
		int remove_controller(FilterController* fc);
		int set_current_filter_controller(int index);
		int set_current_filter_controller(FilterController* fc);


                void draw();
                void followMouse(int x, int y);
                void drag_node(bool isBeginning);
                void add_node();
                void node_setup();
                void filter_setup();
                int process(char* data, int size);

                void deactivate();
                void activate();
		int cleanup();

                QString get_schema();

		Track* assocTrack;

        private:

                FilterController* filterController[MAX_FILTER_CONTROLLERS];
                int currentFilterController;

                bool draggingNode;

                int originX;
                int originY;
                long long originPos;
                float originValue;

                bool isSelectingController;

                friend class Track;
		friend class FilterController;
        };

#include "FilterController.hh"
#include "../Track.hh"


#endif
//eof
