#ifndef FILTERSELECTOR_HH
#define FILTERSELECTOR_HH

#include <mustux.h>

#include <qtimer.h>

class FilterSelector : public MustuxDrawableRegion
        {
        Q_OBJECT

        public:

                static const int MENU_W = 200;
                static const int MENU_H = 300;
                static const int ROW_HEIGHT = 14;
                static const int MAX_FILTER_TYPES=18;
                static QString filterType[MAX_FILTER_TYPES];

                FilterSelector(MustuxDrawable* pDrawArea);
                ~FilterSelector();
                void show_list();
                void start();
                void stop();
                QString get_selected_filter_type();

        private:
                QTimer* updateTimer;
                int rootx;
                int rooty;
                int windowWidth;
                int windowHeight;
                int lastPointedLine;
                int colorChangeVal;
                int colorChangeFactor;

        public slots:
                void update_selection();

        };

#endif
