/**************************************************************************************

	PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
	AUTHOR : See AUTHORS file for details

	This software is distributed under the terms of the GNU General Public License
	as specified in the COPYING file.

***************************************************************************************/
#include "PanController.hh"
#include <mustux.h>

PanController::PanController(FilterChain* chain)
	: FilterController(chain)
	{
	PENTERCONS;
	assocFilter = new Pan(44100,2);
	curveAmountIndex = get_curve_index(add_curve("Amount"));
	set_current_curve(curveAmountIndex);
	PEXITCONS;
	}

PanController::~PanController()
	{
	}

void PanController::node_setup()
	{
	curve[currentCurveIndex]->get_current_curve_node()->setup();
	}


void PanController::setup()
	{
	FilterController::setup();
	}


QString PanController::get_type()
	{
	return "Pan";
	}


void PanController::draw()
	{
	PENTER;
	FilterController::draw();
	PEXIT;
	}

int PanController::process(char* data, int size)
	{
	Song* parentSong = parentChain->assocTrack->parentSong;
	float p = curve[curveAmountIndex]->get_value_at(parentSong->get_playing_block()) / 100;
	((Pan*)assocFilter)->set_pan(p);
	if (assocFilter->load_data(data,size)<0) return -1;
	if (assocFilter->prepare()<0) return -1;
	if (assocFilter->process()<0) return -1;
	return 1;
	}

//eof
