/*
 * Copyright (C) 2005 Jia Wang (skyroam@gmail.com)
 *
 *
 *
 * This file is part of phc.
 * Phc is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by the 
 * Free Software Foundation; either version 2 of the License, or (at your 
 * option) any later version.
 *
 * Phc is distributed in the hope that it will be useful, but WITHOUT ANY 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
 * for more details.
 *
 *
 * You should have received a copy of the GNU General Public License 
 * along with Phc; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

unsigned char en[]="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"
                    "0123456789+/";
unsigned char de[]="\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0>\0\0\0?456789:;<=\0\0\0\0\0\0\0\0\001\002\003\004\005\006\a\b\t\n\v\f\r\016\017\020\021\022\023\024\025\026\027\030\031\0\0\0\0\0\0\032\e\034\035\036\037 !\"#$%&'()*+,-./0123";
int base64en( unsigned char *dst,int dst_max,unsigned char *src,int src_size)
{
    int last_size=src_size%3;
    int dst_size=src_size/3*4+(last_size?4:0);
    unsigned char *last=src+src_size-last_size;
    if(dst_size>dst_max)return -1;
    for(;src<last;src+=3,dst+=4){
        dst[0]=en[src[0]>>2];
        dst[1]=en[((src[0]&3)<<4)+(src[1]>>4)];
        dst[2]=en[((src[1]&0xF)<<2)+(src[2]>>6)];
        dst[3]=en[src[2]&0x3F];
    }
    if(last_size){
        dst[0]=en[last[0]>>2];
        if(last_size==1){ 
            dst[1]=en[(last[0]&3)<<4];
            dst[2]='=';
        }else{
            dst[1]=en[((last[0]&3)<<4)+(last[1]>>4)];
            dst[2]=en[(last[1]&0xF)<<2];
        }
        dst[3]='=';
    }
   return dst_size;
}
int base64de(unsigned char *dst,int dst_max,unsigned char *src,int src_size)
{
    int last_size = (4-(src[src_size-1]=='=')-(src[src_size-2]=='='))%4;
    unsigned char *last = src+src_size-(last_size?4:0);
    int dst_size=src_size/4*3+(last_size?( -3+(last_size-1) ):0);
    if(dst_size>dst_max)return -1;
    for(;src<last;src+=4,dst+=3){
        dst[0]=(de[src[0]]<<2)+(de[src[1]]>>4);
        dst[1]=(de[src[1]]<<4)+(de[src[2]]>>2);
        dst[2]=(de[src[2]]<<6)+de[src[3]];
    }
    if(last_size){
        if(last_size==3)dst[1]=(de[last[1]]<<4)+(de[last[2]]>>2);
        dst[0]=(de[last[0]]<<2)+(de[last[1]]>>4);
    }
    return dst_size;
}
#define MAXLINE 76
int enformat(char *raw,int *len,int size,int linelen,char *news,int newslen)
{   
    int lastsize=*len%linelen?0:1;
    int lines=*len/linelen+lastsize?1:0;
    int offset=linelen*(lines-1);
    int newsbytes=lines*newslen;
    if((*len+=newsbytes)>size)return -1;
    if(lastsize) memmove(raw+offset+lastsize,news,newslen);
    if(lines==1)return 0;
    if(lines>=2)
        for(offset=linelen*(lines-2);offset;offset-=linelen){
            newsbytes -=newslen;
            memmove(raw+offset+newsbytes,raw+offset,newslen);
            memmove(raw+offset+newsbytes+linelen,news,newslen);
        }
    if(lines>2)memmove(raw+linelen,news,newslen);
    return 0;
}
int deformat(unsigned char *buf,int *len,int linelen,char *news,int newslen)
{
  unsigned char *end=buf+*len,*p1,*p2;
  for(p2=(p1=buf);p1<end;p1++){
    if(!strncmp(p1,news,newslen)){
        memmove(p1,p1+newslen , *len-(p1+newslen-buf) );
        if((p1-p2)>linelen)return -1;
        else {
            p2=p1+newslen;
            *len-=newslen;
        }
    }
    if((*p1<43)||(43<*p1<47)||(57<*p1<65)||(90<*p1<97)||(*p2>122)){
            memmove(p1,p1+1,*len-(p1+1-buf));
            *len--;
    }
  }
  return 0;
}

