/*
 * Copyright (C) 2005 Jia Wang (skyroam@gmail.com)
 *
 *
 *
 * This file is part of phc.
 * Phc is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by the 
 * Free Software Foundation; either version 2 of the License, or (at your 
 * option) any later version.
 *
 * Phc is distributed in the hope that it will be useful, but WITHOUT ANY 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
 * for more details.
 *
 *
 * You should have received a copy of the GNU General Public License 
 * along with Phc; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include <phc.h>
/* read .conf and configure global vars */
int readint(char *line,char *flagstring,int *i,int *num)
{
		if( !strncmp(line,flagstring,strlen(flagstring)) ){ 
				*i=atoi(line+strlen(flagstring));
				(*num)++;
				return 0;
		}
		return -1;
}

int readstr(char *line,char *flagstring,char *s,int stringsize,int *num)
{
		int flagsize = strlen(flagstring);
		if( !memcmp(line,flagstring,flagsize) ){
				int len = strlen(line+flagsize) + 1;//including trailling \0
				if( len > stringsize ){
						fprintf(stderr,"%s size too long:>%d",flagstring,stringsize);
						exit(EXIT_FAILURE);
				}
				memmove(s,line+flagsize,len);
				(*num)++;
				return 0;
		}
		return -1;
}
void READCONF()
{
		FILE *conf;
		char *line;
		size_t len;
		ssize_t read;
	    char *offset;
		int set_threads=0,set_myport=0,set_myhost=0,set_myuserpass=0,
			set_checksite=0,set_key=0,set_method=0,set_user_agent=0;
						
		if( (conf=fopen("phc.conf","r"))==NULL ){
				perror("fopen phc.conf");
				exit(EXIT_FAILURE);
		}
		
		while(1){ 
				char *p; 
				line=NULL; 
				read=getline(&line,&len,conf); 
				if(read==-1)break; 
				if(read >0 ){//read=0?  
						if(line[0]=='#')continue;
						if(line[read-1]=='\n') line[read-1]=0;
					    !readint(line,"threads=",&threads,&set_threads)||
						!readint(line,"myport=",&myport,&set_myport)||
						!readstr(line,"myhost=",myhost,sizeof(myhost),&set_myhost)|| 
						!readstr(line,"myuserpass=",myuserpass,sizeof(myuserpass),&set_myuserpass)|| 
						!readstr(line,"checksite=",target,sizeof(target),&set_checksite)||
						!readstr(line,"key=",key,sizeof(key),&set_key)||
						!readstr(line,"user_agent=",user_agent,sizeof(user_agent),&set_user_agent)||
						!readint(line,"method=",&method,&set_method);

				}
				free(line);
		}
														
		if( (fclose(conf) != 0)){
				perror("fclose");
				exit(EXIT_FAILURE);
		}
	   
    sscanf(target,"http://%[^:]:%[^/]%s",target_host,target_port,target_path);
	if( set_myhost*set_myport*set_myuserpass*set_checksite*set_threads*set_key*set_method*set_user_agent == 0){
			fprintf(stderr,"too few config");
			printf("set flag:\n"
							"\tmyhost:%d\n"
							"\tmyport:%d\n"
							"\tmyuserpass:%d\n"
							"\tchecksite:%d\n"
							"\tthreads:%d\n"
							"\tkey:%d\n"
							"\tmethod:%d\n"
							"\tuser_agent:%d\n",
							set_myhost,set_myport,set_myuserpass,
							set_checksite,set_threads,set_key,set_method,
							set_user_agent
				  );
			exit(EXIT_FAILURE);
	}
	printf("setting:\n"
					"\tmyhost=%s\n"
					"\tmyport=%d\n"
					"\tmyuserpass=%s\n"
					"\ttarget=%s\n"
					"\ttarget_host=%s\n"
					"\ttarget_port=%s\n"
					"\ttarget_path=%s\n"
					"\tthreads=%d\n"
					"\tkey=%s\n"
					"\tmethod=%d\n"
					"\tuser_agent=%s\n",
					myhost,myport,myuserpass,
					target,target_host,target_port,target_path,
					threads,key,method,user_agent
		  );

};
