/*
 * Copyright (C) 2005 Jia Wang (skyroam@gmail.com)
 *
 *
 *
 * This file is part of phc.
 * Phc is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by the 
 * Free Software Foundation; either version 2 of the License, or (at your 
 * option) any later version.
 *
 * Phc is distributed in the hope that it will be useful, but WITHOUT ANY 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
 * for more details.
 *
 *
 * You should have received a copy of the GNU General Public License 
 * along with Phc; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include <phc.h>
/* init */
//#include "conf.c"
//#include "base64.c"
void INIT()
{
							
		READCONF();
	    
		if((method!=HTTP_CONNECT)&&(method!=HTTP_GET)){
				fprintf(stderr,"method %d is not supported now\n",method);
				exit(EXIT_FAILURE);
		}

		/* myproxy's ip,authenticate data,useragaent etc */ 
		int blen,dlen;
		if( (blen=strlen(BASIC))>= sizeof(header_auth) ){ 
				fprintf(stderr, "lame code:BASIC longer than header_auth\n"); 
				exit(EXIT_FAILURE); 
		}       
		memmove(header_auth,BASIC,blen); 
		dlen= base64en(header_auth+blen,MYSIZE-blen, 
						myuserpass,strlen(myuserpass)); 
		if(dlen==-1) { 
				fprintf(stderr,"error:base64encode\n"); 
				exit(EXIT_FAILURE); 
		}       
/* debug */	
		printf("%s\n",header_auth);
		
		struct hostent *h; 
		if( (h=gethostbyname(myhost))==NULL ){ 
				herror("gethostbyname"); 
				exit(EXIT_FAILURE); 
		}else myip=*(struct in_addr *)(h->h_addr);
/* debug */
	    printf("addr=%s\n",inet_ntoa(myip));
		myaddr.sin_family = AF_INET;
		myaddr.sin_addr = myip;
		myaddr.sin_port = htons(myport);
		memset(&(myaddr.sin_zero),0,sizeof(myaddr.sin_zero));

		if( (in=fopen("proxylist","r")) == NULL){
				perror("fopen proxylist");
				exit(EXIT_FAILURE);
		}
		if( (out=fopen("proxyout","w"))==NULL ){ 
				perror("fopen proxylist"); 
				exit(EXIT_FAILURE);
		}
		setvbuf(out,(char *)NULL,_IONBF,0); 
		setvbuf(stdout,(char *)NULL,_IONBF,0); 
		setvbuf(stderr,(char *)NULL,_IONBF,0);

};

/* setup loop */
#define MAXTHREADS 65535
//#include "loop.c"
void THREAD()
{
		int tidnum[MAXTHREADS],mainret,i;
		pthread_t tid[MAXTHREADS];//1023for user
		void *status;

		if((threads>MAXTHREADS)||(threads<1)){ 
				fprintf(stderr,"threads between [1,65535] is permitted!" 
								"please modify \"thread=\" in .conf"
								"then  try again.\n"); 
				exit(EXIT_FAILURE); 
		}
	    for(i=0;i<threads;i++){ 
				tidnum[i]=i;
        		if((mainret=pthread_create(tid+i,NULL,loop,tidnum+i))==0){
						//printf("thread %d create %d\n",i,tid[i]); 
				}else{ 
						printf("errno=%d\n",mainret); 
						errno=mainret; 
						perror("pthread_create!!!"); 
						exit(EXIT_FAILURE); 
				} 
		}
		for(i=0;i<threads;i++){ 
				if(pthread_join(tid[i],&status)==0){ 
						//printf("join thread %d\n",i,*(int *)status); 
				}else{ 
						perror("pthread_join"); 
						exit(EXIT_FAILURE); 
				} 
		}
			
};

/* clean memory */
void END()
{
		fclose(in);
		fclose(out);
};
		
		
