/*
 * Copyright (C) 2005 Jia Wang (skyroam@gmail.com)
 *
 *
 *
 * This file is part of phc.
 * Phc is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by the 
 * Free Software Foundation; either version 2 of the License, or (at your 
 * option) any later version.
 *
 * Phc is distributed in the hope that it will be useful, but WITHOUT ANY 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
 * for more details.
 *
 *
 * You should have received a copy of the GNU General Public License 
 * along with Phc; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include <phc.h>
pthread_mutex_t counter_mutex_in = PTHREAD_MUTEX_INITIALIZER;
pthread_mutex_t counter_mutex_out = PTHREAD_MUTEX_INITIALIZER;
pthread_mutex_t counter_mutex_create = PTHREAD_MUTEX_INITIALIZER;
//#include "check.c"
/* thread order: *((int *)arg) */
int READAPROXY(char * testproxy)
{
		char * line=NULL;
		size_t mlen ;
		ssize_t read;
		
		pthread_mutex_lock(&counter_mutex_in);
		read = getline(&line, &mlen, in);
		pthread_mutex_unlock(&counter_mutex_in);
		
		if(read == -1) goto ex;/* -1 means end of file,but 0 ? */
		                        /* if end,should terminated here */
		if(line[read-1]=='\n') line[read-1]='\x0';
		if(checkaline(in,line,read,testproxy,MYSIZE,1)==-1) read=-2;
		//if(checkaline(in,line,testproxy,MYSIZE,1)==-1) read=-2;
ex:		
		free(line);			
		return read;/* -1 means end of file */
		
		
};
int CONNECTVIA(int sockfd,char *testproxy,
				struct timeval *start,struct timeval *end)
{
		int ret;
		char request[MYSIZE],*p;
		
		ret=connect(sockfd,(struct sockaddr *)&myaddr,sizeof(struct sockaddr));
		if( ret== -1){
				perror("connect to myaddr");
				return -1;
		}
		
		/* build request */
		snprintf(request,sizeof(request),
						"CONNECT %s HTTP/1.0\r\n"
						"%s\r\n"
						"%s\r\n"
						"%s\r\n"
						"\r\n",
						testproxy,
						user_agent,
						NOCACHE,
						header_auth
				);
		/* send */
		gettimeofday(start,NULL);
		ret=write(sockfd,request,strlen(request));
		if( ret != strlen(request) ){
			fprintf(stderr,"CONVIA--write:\n"); 
			if(ret == -1) perror("CONVIA--write"); 
			return -1;
                }
		
		/* read estab string */
		memset(request,0,sizeof(request));
                p=request;
		while( (ret = read(sockfd,p,sizeof(request) - (p - request) - 1)) >0 ){;
		/* repaired */
			gettimeofday(end,NULL);
		//if(ret < strlen(CONNECT_SUCCESS))return -1;
			if((strstr(request,CONNECT_SUCCESS0)!=NULL)||(strstr(request,CONNECT_SUCCESS1)!=NULL)) return 0;
			p += ret;
			if( (p - request) == (sizeof(request) -1) ) break;//too long 
		}
		//too long or read return 0/-1
		fprintf(stderr,"reply to convia is wrong:%s\n",request); 
		return -1;
}
int GET(int sockfd,struct timeval *send)
{ 
		int numbytes;
		char request[MYSIZE];
		/* build request string */
		snprintf(request,sizeof(request),
						"GET %s HTTP/1.0\r\n"
						"Host: %s\r\n"
						"%s\r\n%s\r\n"
						"\r\n",
						target,
						target_host,
						user_agent,NOCACHE);//remove header_auth!
		/* send */
		gettimeofday(send,NULL);
		numbytes=write(sockfd,request,strlen(request));
		if(numbytes!=strlen(request)){
			fprintf(stderr,"GET--write:\n");
			if(numbytes <0)perror("GET--write");
			return -1;/* ... */
		}
	
		return numbytes;
}
int CONN(int sockfd,struct timeval *start,struct timeval *end,
				struct timeval *req)
{ 
		int numbytes;
		char request[MYSIZE],*p;
		/* build request string */
		snprintf(request,sizeof(request),
						"CONNECT %s:%s HTTP/1.0\r\n"
						"Host: %s\r\n"
						"%s\r\n%s\r\n"
						"\r\n",
						target_host,target_port,
						target_host,
						user_agent,NOCACHE);//remove header_auth!
		/* send */
		gettimeofday(start,NULL);
		numbytes=write(sockfd,request,strlen(request));
		if(numbytes!=strlen(request)){
			fprintf(stderr,"CONCON-writecon:\n");
			if(numbytes <0) perror("CONCON-writecon");
			return -1;/* ... */
		}
	        
		/* read estab string */
		memset(request,0,sizeof(request));
		p = request;
		while( (numbytes=read(sockfd,p,sizeof(request) - (p - request) - 1)) >0 ){ /* need repaired */ 
			gettimeofday(end,NULL);
		//if(numbytes < strlen(CONNECT_SUCCESS))return -1;
			if( (strstr(request,CONNECT_SUCCESS0) != NULL)||(strstr(request,CONNECT_SUCCESS1) != NULL) ) break; 
			p += numbytes; 
			if( (p - request) == sizeof(request) -1 ){
				fprintf(stderr,"reply to concon is wrong:%s\n",request);
				return -1;
			}
		}
		if( numbytes <=0 ){
				fprintf(stderr,"reply to concon is wrong:%s\n",request);
				return -1;
		}
		
		/* send req */
		snprintf(request,sizeof(request),
						"GET %s HTTP/1.0\r\n"
						"Host: %s\r\n"
						"%s\r\n%s\r\n"
						"\r\n",
						target_path,
						target_host,
						user_agent,NOCACHE
						);
		gettimeofday(req,NULL);
		numbytes=write(sockfd,request,strlen(request));
		if(numbytes!=strlen(request)){
			fprintf(stderr,"concon-writereq:\n");
			if(numbytes < 0) perror("concon-writereq");
			return -1;/* ... */
		}
		return numbytes;
}
int VERIFY(int sockfd,struct timeval *finddata,struct timeval *findkey)
{
		int numbytes;
		char buf[BUFSIZE],*p;//danger?
		int t=0;
		p = buf; 
		memset(buf,0,sizeof(buf));
		/* -1 for \0 ->strstr */
		while((numbytes=read(sockfd,p,sizeof(buf) - (p - buf) -1))>0){
				t++;
				if(t==1)gettimeofday(finddata,NULL);
				//printf("RETURN!!!!!!!!!!!!!!!%s",buf);
				if(strstr(buf,key)!=NULL){
						gettimeofday(findkey,NULL);
						return 0; 
				}
				p += numbytes;
				if( (p - buf) == (sizeof(buf) - 1) ) break;
		};
		return -1;
}
#include <sys/time.h>			
void *loop(void *arg)
{
		char testproxy[MYSIZE];
		int read,sockfd;
		struct timeval start_via,end_estab,start_GET,enter_data,enter_key;
		struct timeval start_CONN,end_CONN;
		while(1){
				read=READAPROXY(testproxy);
				if( read == -1 )break;//end of file
				if( read == -2 )continue; 
				/* create socket */
				if( (sockfd=socket(AF_INET,SOCK_STREAM,0))==-1){
						fprintf(stderr,"thread %d---",*((int *)arg));
						perror("create socket"); 
						break;//fatal thread error. 
				}
				printf("thread %d Checking %s\n",*(int *)arg,testproxy);
				/* connect to testproxy via myproxy*/
				if(CONNECTVIA(sockfd,testproxy,&start_via,&end_estab)==-1)goto loop_ex;
				/* protocol will be added here in the future */
				
				switch(method){
						case HTTP_GET: 
								if(GET(sockfd,&start_GET)==-1)goto loop_ex;
				/* verify the result */ 
								if(VERIFY(sockfd,&enter_data,&enter_key)==0){ 
										printf("Thread %d--Found!!!!!!%s delay=%f %f %f\n"
														,*((int *)arg),testproxy,
								time_sub(end_estab,start_via),
								time_sub(enter_data,start_GET),
								time_sub(enter_key,enter_data)
								);
										pthread_mutex_lock(&counter_mutex_out);
										fprintf(out,"%s@HTTP\t%f %f %f\n",
														testproxy,
								time_sub(end_estab,start_via),
								time_sub(enter_data,start_GET),
								time_sub(enter_key,enter_data)
								); 
										pthread_mutex_unlock(&counter_mutex_out);
								}
								break;
					 	case HTTP_CONNECT:
								if(CONN(sockfd,&start_CONN,&end_CONN,&start_GET) == -1)goto loop_ex;
								if(VERIFY(sockfd,&enter_data,&enter_key)==0){
										printf("Thread %d--Found!!!!!%s delay=%f %f %f %f\n",*((int *)arg),testproxy,
                                                                                        time_sub(end_estab,start_via), 
                                                                                        time_sub(enter_data,start_GET), 
                                                                                        time_sub(enter_key,enter_data), 
                                                                                        time_sub(end_CONN,start_CONN)
											  ); 
										fprintf(out,"%s@HTTP %f %f %f %f\n",testproxy,
                                                                                        time_sub(end_estab,start_via), 
                                                                                        time_sub(enter_data,start_GET), 
                                                                                        time_sub(enter_key,enter_data), 
                                                                                        time_sub(end_CONN,start_CONN)
											  );
								}
								break;
						default://not necessay,should be done in init
								fprintf(stderr,"error:unknown method!\n");
								break;
				}
loop_ex:				
				close(sockfd);
		}
return arg;
};
