/*
 * Copyright (C) 2005 Jia Wang (skyroam@gmail.com)
 *
 *
 *
 * This file is part of phc.
 * Phc is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by the 
 * Free Software Foundation; either version 2 of the License, or (at your 
 * option) any later version.
 *
 * Phc is distributed in the hope that it will be useful, but WITHOUT ANY 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
 * for more details.
 *
 *
 * You should have received a copy of the GNU General Public License 
 * along with Phc; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include<phc.h>
#include<stdlib.h>
#include<stdio.h>

/* need a speed version including last line */
/* fgets may no use for lines in every length */
int
getaline (unsigned char **line, int *size, FILE * f)
{
  unsigned char *p, *q, ret;
  int offset, n, D = 256;

  if (*size <= 0)
    return -1;

  if (*line == NULL)
    {
      p = malloc (*size);
      if (p == NULL)
	{
	  *line = NULL;		/*no memory allocated,no need clean mem */
	  /* return -1; */
	  xexit (EXIT_FAILURE);
	}
    }
  else
    {
      p = *line;
    }

  offset = 0;
  while (1)
    {
      if (offset + 2 > *size)
	{
	  *size += D;
	  q = realloc (p, *size);
	  if (q == NULL)
	    {
	      *line = p;
	      /* return -1; */
	      xexit (EXIT_FAILURE);
	    }
	  else
	    p = q;
	}
      n = fread (p + offset, 1, 1, f);
      if (n != 1)
	{
	  *line = p;
	  return -1;
	}
      if (p[offset] == '\n')
	{
	  p[offset + 1] = '\0';	/* total offset+2 len */
	  *line = p;
	  return (offset + 1);	/* including '\n'; */
	}
      offset++;
    }
}

/* thread version, for safe need a mutex outside */

int
getaline_r (char **line, int *size, FILE * f, struct thread_mem *thread_mem)
{
  char *p, *q, *s;
  int offset, n, D = 256, linelen, len;
  linelen = 80;

  if (*size <= 0)
    return -1;

  if (*line == NULL)
    {
      p = pxmalloc (*size, thread_mem);	/* error to pthread_exit  in pmalloc */
    }
  else
    {
      p = *line;
    }

  offset = 0;
  while (1)
    {
      if (offset + linelen > *size)
	{
	  *size = offset + linelen + D;
	  q = pxrealloc (p, *size, thread_mem);
	  p = q;
	}

      /* ftell */
      s = fgets (p + offset, linelen, f);
      /* ftell ,sub= read */


      if (s == NULL)
	{
	  *line = p;		/* for free */
	  return -1;		/*  end of file or errors */
	}
      else
	{
	  len = strlen (p + offset);
	  if (*(p + offset + len - 1) == '\n')
	    {
	      *line = p;
	      return (offset + len);	/* including '\n'; */
	    }
	  else
	    {
	      offset += len;
	    }
	}
    }
}
