/* readconf.c - routines used to read configuration file and set global vars
 * Copyright (C) 2005 Jia Wang (skyroam@gmail.com)
 *
 *
 *
 * This file is part of phc.
 * Phc is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by the 
 * Free Software Foundation; either version 2 of the License, or (at your 
 * option) any later version.
 *
 * Phc is distributed in the hope that it will be useful, but WITHOUT ANY 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
 * for more details.
 *
 *
 * You should have received a copy of the GNU General Public License 
 * along with Phc; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* all functions declared in pyhc.h */
#include <phc.h>
/* functions defined in this file */
int readint (char *line, char *flagstring, int *i, int *num);
int readstr (char *line, char *flagstring, char **s, int *num);
void optstr (char *value,char **s, int *num);
void optint (char *value, int *i, int *num);

#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>
extern int h_errno;
#include <string.h>
/* for getopt */
#include <unistd.h>
extern char *optarg;
extern int optind, opterr, optopt;

void usage()
{
        fprintf(stderr,"Phc 1.2, a customizable proxy hunter.\n\
Usage: phc [OPTION]...\n\
\n\
-V \tdisplay the version of Phc and exit.\n\
\n\
All of the other options need arguments!\n\
\n\
Commandline only options:\n\
-f \tthe argument is configuration file\n\
\n\
Configuration options:\n\
-t \tthreads\n\
-g \tuser_agent\n\
-m \tmytype, the type of myproxy.\n\
-p \tmyport, the port of myproxy.\n\
-h \tmyhost, the ip or domainname of myproxy.\n\
-u \tmyuser, the username of myproxy if need.\n\
-s \tmypass, the password of myproxy if need.\n\
-c \tchecksite, the target site used to check testproxies.\n\
-k \tkey, the keyword used to check whether testproxies give correct response.\n\
-r \trcvtimeo, socket recv timeout in seconds.\n\
-n \tsndtimeo, socket send timeout in seconds.\n\
-S \tmyconreplysize\n\
-T \ttestconreplysize\n\
-G \ttesttagreplysize\n\
-H \thttptestmethod\n\
-5 \tsocks5testmethod\n\
-4 \tsocks4testmethod\n\
-l \tlogfilename\n\
-i \tphcin, the proxylist file used as input of phc.\n\
-o \tphcout, the file which phc output result to. \n"
);
}

/* Read file PHC_CONF and configure global vars */
void
READCONF (int argc, char **argv)
{
  FILE *conf;char *phc_conf=NULL;
  char *line;
  /* malloc at least linelen for a line */
  int linelen;
  int stringlen;
  ssize_t read;
  char *offset;
  char *p, *q;
  /* must be customized */
  int set_mytype = 0, set_httptestmethod = 0, set_socks5testmethod = 0, set_socks4testmethod = 0;
  /* useful only if mytype != DIRECT */
  int set_myport = 0, set_myhost = 0;
  /* userful only if mytype = xx_AUTH */
  int set_myuser = 0, set_mypass = 0;
  /* The following is customizable and  is also ok to use the value in 
     example. But do not remove or comment any of the following.
   */
  int set_threads = 0, set_checksite = 0, set_key = 0, set_logfilename = 0;
  int set_user_agent = 0, set_myconreplysize = 0, set_testconreplysize = 0;
  int set_testtagreplysize = 0, set_rcvtimeo = 0, set_sndtimeo = 0;
  int set_phcin = 0,set_phcout=0;

  struct hostent *h;

  int slash, colon;
  unsigned char *path,*home;
  int pathlen;
  
  
  /* for command option */
  int c;

  /* init inputfile ,outputfile */
  phc_in = NULL;
  phc_out = NULL;

  while(1){
          c = getopt(argc,argv,"Vf:i:o:t:g:m:p:h:u:s:c:k:r:n:S:T:G:H:5:4:l:");
          if(c == -1)
                  break;
          switch(c){
                  case 'f':
                          printf("Check %s firstly\n",optarg);
                          phc_conf = xmalloc(strlen(optarg)+1);
                          memset(phc_conf,strlen(optarg)+1,0);
                          memmove(phc_conf,optarg,strlen(optarg));
                          break;
		  case 'V':
			  printf("Phc 1.2\n"
					  "\n"
"Copyright (C) 2005 Jia Wang <skyroam@gmail.com>.\n\
Phc is distributed in the hope that it will be useful,\n\
but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the\n\
GNU General Public License for more details.\n"
					  );
			  exit(EXIT_SUCCESS);
		  case 'i':
                          optstr(optarg,&phc_in,&set_phcin);
                          break;
                  case 'o':
                          optstr(optarg,&phc_out,&set_phcout);
                          break;
                  case 't':
                          optint(optarg,&threads,&set_threads);
                          break;
                  case 'g':
                          optstr(optarg,
                                          &user_agent,
                                          &set_user_agent);
                          break;
                  case 'm':
                          optint(optarg,&(my.mytype), &set_mytype);
                          break;
                  case 'p':
                          optint(optarg,&(my.myport), &set_myport);
                          break;
                  case 'h':
                          optstr(optarg, &(my.myhost), &set_myhost);
                          break;
                  case 'u':
                          optstr(optarg, &(my.myuser), &set_myuser);
                          break;
                  case 's':
                          optstr(optarg, &(my.mypass), &set_mypass);
                          break;
                  case 'c':/* checksite */
                          optstr(optarg,&(target.target), &set_checksite);
                          break;
                  case 'k':/* "key=" */
                          optstr(optarg,&(target.key), &set_key);
                          break;
                  case 'r':/*"rcvtimeo="*/
                          optint(optarg, &(rcvtimeo), &set_rcvtimeo);
                          break;
                  case 'n':/*"sndtimeo="*/
                          optint(optarg, &(sndtimeo), &set_sndtimeo);
                          break;
                  case 'S':/*"myconreplysize="*/
                          optint(optarg, &(my.myconreplysize),
                                          &set_myconreplysize);
                          break;
                  case 'T':/* "testconreplysize="*/
                          optint(optarg, &(test.testconreplysize),
                                          &set_testconreplysize);
                          break;
                  case 'G':/* "testtagreplysize=" */
                          optint(optarg, &(test.testtagreplysize),
                                          &set_testtagreplysize);
                          break;
                  case 'H':/* "httptestmethod="*/
                          optint(optarg, &(test.httptestmethod),
                                          &set_httptestmethod);
                          break;
                  case '5': /* "socks5testmethod="*/
                          optint(optarg, &(test.socks5testmethod),
                                          &set_socks5testmethod);
                          break;
                  case '4':/*"socks4testmethod="*/
                          optint(optarg, &(test.socks4testmethod),
                                          &set_socks4testmethod);
                          break;
                  case 'l':/*"logfilename="*/
                          optstr(optarg, &(logfilename), &set_logfilename);
                          break;

                  default:
                          usage();
                          exit(EXIT_FAILURE);
                          break;
          }
  }

  conf = fopen(phc_conf,"r");
  if(conf == NULL){
          perror("READCONF:fopen:the configuration file in commandline");
  
          conf = fopen (PHC_CONF, "r");
          if (conf == NULL) {
                  perror (__FILE__" " "READCONF:fopen:" PHC_CONF); 
                  /* check ~/.phc.conf */
                  home = getenv("HOME");
                  if(home!=NULL){
                          pathlen = strlen(home)+strlen(PHC_CONF)+strlen("/.");
                          path = xmalloc(pathlen+1);
                          memset(path,0,pathlen);
                          snprintf(path,pathlen+1,"%s/.%s",home,PHC_CONF);
                          conf = fopen(path,"r");
                          if(conf == NULL){
                                  perror("READCONF:fopen:~/."PHC_CONF);
                          }else{
                                  printf("Using ~/."PHC_CONF"\n");
                          }
                          xfree((void **)&path);
                  }
          } else {
                  printf("READCONF:Using "PHC_CONF"\n");
          } 
  }else {
          printf("READCONF:Using %s\n",phc_conf);
  }

  xfree((void **)&phc_conf);
      /* check  /etc/phc.conf */
      /* error  was deal above, 
         so there will not be  duplicate reports of errors  here */
      if( conf == NULL ){
              pathlen = strlen(PHC_CONF)+strlen("/etc/");
              path = xmalloc(pathlen);
              memset(path,0,pathlen);
              snprintf(path,pathlen,"/etc/%s",PHC_CONF);
              conf = fopen(path,"r");
              if(conf == NULL){
                      perror("READCONF:fopen:/etc/"PHC_CONF);
                      fprintf(stderr,"READCONF:FATAL ERROS: Can't find phc.conf");
                      xexit (EXIT_FAILURE);
              }else{
                      printf("Using /etc/"PHC_CONF"\n");
              }
      }

  slash = '/';
  colon = ':';


  while (1)
    {
      line = NULL;
      linelen = 80;
      read = getaline ((unsigned char **) &line, &linelen, conf);
      if (read == -1)
	break;
      if (read > 0)
	{			/*read=0?  */
	  if (line[0] == '#')
	    continue;
	  if (line[read - 1] == '\n')
	    line[read - 1] = 0;
	  !readint (line, "threads=", &threads, &set_threads)
	    || !readstr (line, "user_agent=", &user_agent, &set_user_agent)
	    || !readint (line, "mytype=", &(my.mytype), &set_mytype)
	    || !readint (line, "myport=", &(my.myport), &set_myport)
	    || !readstr (line, "myhost=", &(my.myhost), &set_myhost)
	    || !readstr (line, "myuser=", &(my.myuser), &set_myuser)
	    || !readstr (line, "mypass=", &(my.mypass), &set_mypass)
	    || !readstr (line, "checksite=", &(target.target), &set_checksite)
	    || !readstr (line, "key=", &(target.key), &set_key)
	    || !readint (line, "rcvtimeo=", &(rcvtimeo), &set_rcvtimeo)
	    || !readint (line, "sndtimeo=", &(sndtimeo), &set_sndtimeo)
	    || !readint (line, "myconreplysize=", &(my.myconreplysize),
			 &set_myconreplysize)
	    || !readint (line, "testconreplysize=", &(test.testconreplysize),
			 &set_testconreplysize)
	    || !readint (line, "testtagreplysize=", &(test.testtagreplysize),
			 &set_testtagreplysize)
	    || !readint (line, "httptestmethod=", &(test.httptestmethod),
			 &set_httptestmethod)
	    || !readint (line, "socks5testmethod=", &(test.socks5testmethod),
			 &set_socks5testmethod)
        || !readint (line, "socks4testmethod=", &(test.socks4testmethod),
             &set_socks4testmethod)
	    || !readstr (line, "logfilename=", &(logfilename),
			 &set_logfilename)
        || !readstr (line, "phcin=",&(phc_in),&set_phcin)
        || !readstr (line, "phcout=",&(phc_out),&set_phcout);
	}
      if (line)
	free (line);
    }

  if (fclose (conf) != 0)
    {
      perror ("READCONF:fclose:" PHC_CONF);
      xexit (EXIT_FAILURE);
    }
  if (set_mytype * set_httptestmethod * set_socks5testmethod * set_rcvtimeo
      * set_sndtimeo * set_checksite * set_threads * set_key * set_user_agent
      * set_myconreplysize * set_testconreplysize * set_testtagreplysize
      * set_logfilename == 0)
    {
      fprintf (stderr, "%s: READCONF:too few config parameters:", progname);
      fprintf (stderr, "set flag are checked:\n"
	       "\tmytype:%d\n"
	       "\thttptestmethod:%d\n"
	       "\tsocks5testmethod:%d\n"
           "\tsocks4testmethod:%d\n"
	       "\trcvtimeo:%d\n"
	       "\tsndtimeo:%d\n"
	       "\tchecksite:%d\n"
	       "\tthreads:%d\n"
	       "\tkey:%d\n"
	       "\tuser_agent:%d\n"
	       "\tmyconreplysize:%d\n"
	       "\ttestconreplysize:%d\n"
	       "\ttesttagreplysize:%d\n"
	       "\tlogfilename:%d\n",
	       set_mytype, set_httptestmethod, set_socks5testmethod,
           set_socks4testmethod,
	       set_rcvtimeo, set_sndtimeo,
	       set_checksite, set_threads, set_key, set_user_agent,
	       set_myconreplysize, set_testconreplysize,
	       set_testtagreplysize, set_logfilename);
      xexit (EXIT_FAILURE);
    }

  if (my.mytype != DIRECT)
    {
      if (set_myhost * set_myport == 0)
	{
	  fprintf (stderr,
		   "%s: READCONF:Parameters:myhost or myport isn't set!\n",
		   progname);
	  xexit (EXIT_FAILURE);
	}
      if ((my.mytype == HTTP_CONNECT_AUTH)
	  || (my.mytype == SOCKS5_CONNECT_AUTH))
	{
	  if ((set_myuser == 0) || (set_mypass == 0))
	    {
	      fprintf (stderr,
		       "%s: READCONF:Parameters:myuser or mypass isn't set\n",
		       progname);
	      xexit (EXIT_FAILURE);
	    }
	}
    }
  else
    {
/*fprintf (stderr,
	       "%s: READCONF:Parameters:mytype:DIRECT is not supported now\n",
	       progname);
      xexit (EXIT_FAILURE);
      */
    }

  /* http://$targethost:$targetport$targetpath */
  /* Parse it here to stop phc early and let user know the error in conf */
  p = strstr ((const char *) target.target, (const char *) "http://");
  if (p == NULL)
    {
      fprintf (stderr, "%s: READCONF:No http:// found in %s\n", progname,
	       target.target);
      xexit (EXIT_FAILURE);
    }
  p += (int) strlen ("http://");
  q = strchr (p, colon);
  if (q == NULL)
    {
      fprintf (stderr, "%s :No ':' found in %s\n", progname, p);
      xexit (EXIT_FAILURE);
    }
  stringlen = q - p;
  target.targethost = xmalloc (stringlen + 1);
  memmove (target.targethost, p, stringlen);
  target.targethost[stringlen] = '\0';
  /* move p after ':' */
  p = q + 1;
  q = strchr (p, slash);
  if (q == NULL)
    {				/* add fix in the future */
      fprintf (stderr, "%s: READCONF:No / found in %s\n", progname, p);
      xexit (EXIT_FAILURE);
    }
  stringlen = q - p;
  target.targetport = xmalloc (stringlen + 1);
  memmove (target.targetport, p, stringlen);
  /* fprintf(stderr,"%d %s %s\n",stringlen,p,q); */
  target.targetport[stringlen] = '\0';

  /* path */
  stringlen = strlen (q);
  target.targetpath = xmalloc (stringlen + 1);
  memmove (target.targetpath, q, stringlen);
  target.targetpath[stringlen] = '\0';

  /*sscanf ((const char *) target, "http://%[^:]:%[^/]%s", target_host,
     target_port, target_path); */

  h = gethostbyname (target.targethost);

  if (h == NULL)
    {
      herror (target.targethost);
      xexit (EXIT_FAILURE);
    }

  /* init target.targetaddr,used to validate socks5 proxy */
  target.targetaddr.sin_addr = *(struct in_addr *) (h->h_addr);
  target.targetaddr.sin_port = htons (atoi (target.targetport));
  target.targetaddr.sin_family = AF_INET;
  memset (&(target.targetaddr.sin_zero), 0,
	  sizeof (target.targetaddr.sin_zero));


  /* phc_in, phc_out */

  /* If no NULL options or NULL configuration lines */
  if( phc_in == NULL){
          optstr(PHC_IN,&phc_in,&set_phcin);
  }
  if( phc_out == NULL){
          optstr(PHC_OUT,&phc_out,&set_phcout);
  }

  printf ("setting:\n"
	  "\tlogfilename=%s\n"
	  "\ttarget=%s\n"
	  "\ttargethost=%s\n"
	  "\ttargetport=%s\n"
	  "\ttargetpath=%s\n"
	  "\tkey=%s\n"
	  "\thttptestmethod=%d\n"
	  "\tsocks5testmethod=%d\n"
      "\tsocks4testmethod=%d\n"
	  "\tthreads=%d\n"
	  "\tuser_agent=%s\n"
	  "\trcvtimeo=%d\n"
	  "\tsndtimeo=%d\n"
	  "\ttestconreplysize=%d\n"
	  "\ttesttagreplysize=%d\n"
      "\tphc_in=%s\n"
      "\tphc_out=%s\n",
	  logfilename, target.target, target.targethost, target.targetport,
	  target.targetpath, target.key, test.httptestmethod,
	  test.socks5testmethod, test.socks4testmethod, threads, user_agent,
	  rcvtimeo, sndtimeo, test.testconreplysize, test.testtagreplysize,
      phc_in,phc_out);
  switch (my.mytype)
    {
      /*case DIRECT:
         printf("\tmytype=DIRECT\n");
         break; */
    case HTTP_CONNECT:
      printf ("\tmytype=HTTP_CONNECT\n");
      printf ("\tmyhost=%s\n\tmyport=%d\n", my.myhost, my.myport);
      break;
    case HTTP_CONNECT_AUTH:
      printf ("\tmytype=HTTP_CONNECT_AUTH\n");
      printf ("\tmyhost=%s\n\tmyport=%d\n", my.myhost, my.myport);
      printf ("\tmyuser=%s\n\tmypass=%s\n", my.myuser, my.mypass);
      break;
    case SOCKS5_CONNECT:
      printf ("\tmytype=SOCKS5_CONNECT\n");
      printf ("\tmyhost=%s\n\tmyport=%d\n", my.myhost, my.myport);
      break;
    case SOCKS5_CONNECT_AUTH:
      printf ("\tmytype=SOCKS5_CONNECT_AUTH\n");
      printf ("\tmyhost=%s\n\tmyport=%d\n", my.myhost, my.myport);
      printf ("\tmyuser=%s\n\tmypass=%s\n", my.myuser, my.mypass);
      break;
    efault:
      printf ("\tinvalid mytype:%d\n", my.mytype);
      break;
    }
}

/* Read the int after flagstring.
 * 
 * Return value:
 * 0: success!
 * -1: no flagstring found at the head of line.
 * */
int
readint (char *line, char *flagstring, int *i, int *num)
{
  if (!strncmp (line, flagstring, strlen (flagstring)))
    {
            if(*num){
                    fprintf(stderr,"Duplicate configuration:%s -- ignored!\n",line);
                    return 0;/* do not match it with other options */
                    //exit(EXIT_FAILURE);
            }else{
      *i = atoi (line + strlen (flagstring));
      (*num)++;
      return 0;
            }
    }
  return -1;
}

/* Store  string after flagstring to *s 
 *
 * Return value:
 * 0: success!
 * -1: no flagstring found at the head of line.
 * */
int
readstr (char *line, char *flagstring, char **s, int *num)
{
  int flagsize, len;
  flagsize = strlen (flagstring);

  if (!strncmp (line, flagstring, flagsize))
    {
      /* duplication */
      if (*num)
	{
            fprintf(stderr,"Duplicate configuration:%s -- ignored!\n",line);
            return 0;/* do not check it  with other options */
            //exit(EXIT_FAILURE);
	}else{

      len = strlen (line) - flagsize + 1;
      *s = xmalloc (len);
      memmove (*s, line + flagsize, len);
      (*num)++;
      return 0;
    }
    }
  return -1;
}

/* read a string option from commandline */
void 
optstr (char *value,char **s, int *num)
{
  
        int len;
      /* check  duplication */
        if(*num){
                fprintf(stderr,"Duplication commandline options: %s!\n",value);
                exit(EXIT_FAILURE);
        }else {
            //xfree(s);
            len = strlen (value) + 1;
            *s = xmalloc (len);
            memmove (*s, value, len);
            (*num)++;
        }
}
/* read a int option from commandline */
void 
optint (char *value, int *i, int *num)
{
            
        if(*num){
                    fprintf(stderr,"Duplicate commandline options :%s \n",value);
                    exit(EXIT_FAILURE);
            }else{

      *i = atoi (value);
      (*num)++;
            }
}
