/* Copyright (C) 2012 Rudra Banerjee*/

/*
This file is part of ptbl.

ptbl is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

ptbl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with ptbl.  If not, see <http://www.gnu.org/licenses/>.

*/

#include <gtk/gtk.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>

GtkWidget *window;
 void helpabout_activated (GtkMenuItem *helpabout, GtkWindow *window)
{
  const gchar *auth[]={ "Rudra Banerjee <bnrj.rudra@yahoo.com>", NULL };
  GdkPixbuf *pixbuf = gdk_pixbuf_new_from_file("../images/ptbl.png", NULL);

  GtkWidget *dialog = gtk_about_dialog_new();
  gtk_about_dialog_set_program_name(GTK_ABOUT_DIALOG(dialog), "ptbl");
  gtk_about_dialog_set_authors(GTK_ABOUT_DIALOG(dialog), auth);
  gtk_about_dialog_set_version(GTK_ABOUT_DIALOG(dialog), "1.0"); 
  gtk_about_dialog_set_copyright(GTK_ABOUT_DIALOG(dialog),"Copyright 2012-2013 ©Rudra Banerjee");
  gtk_about_dialog_set_comments(GTK_ABOUT_DIALOG(dialog), 
     "This is a simple bibtex maker \nwhich can be used to create standard bibtex file");
  gtk_about_dialog_set_website(GTK_ABOUT_DIALOG(dialog), 
      "http://web.warwick.ac.uk/~phslav/packs.html#ptbl");
  gtk_about_dialog_set_license(GTK_ABOUT_DIALOG(dialog),
  "  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version. \n  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details. \n  You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA" );    
  gtk_about_dialog_set_wrap_license(GTK_ABOUT_DIALOG(dialog),TRUE);
  gtk_about_dialog_set_logo(GTK_ABOUT_DIALOG(dialog), pixbuf);
  g_object_unref(pixbuf), pixbuf = NULL;
  gtk_dialog_run(GTK_DIALOG (dialog));
  gtk_widget_destroy(dialog);

}
void helpfhelp(GtkWidget *widget, gpointer data)

{
  	gchar *uri, *str;
	GError *Err=NULL;

	uri=g_strdup("ghelp:ptbl-manual");
	gtk_show_uri(NULL, uri, gtk_get_current_event_time(), &Err);
	g_free(uri);
	if (Err)
	{
//	  caution("File does not exist");
	}
}


