/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import org.nongnu.pulsefire.device.ui.JPanelConsole;
import org.nongnu.pulsefire.device.ui.JPanelConsoleInfo;
import org.nongnu.pulsefire.device.ui.JTopPanelSerial;
import org.nongnu.pulsefire.device.ui.JTopPanelStatus;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.device.ui.PulseFireUISettingKeys;
import org.nongnu.pulsefire.device.ui.tabs.JTabFirePanel;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelGraphs;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelInput;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelLPM;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelMAL;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelPTC;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelPTT;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelPWM;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelPins;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelSTV;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelScope;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelSettings;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelSystem;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelVFC;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelVariables;

public class JMainPanel
extends JPanel {
    private static final long serialVersionUID = -9173866662540287337L;
    private List<JTabFirePanel> tabPanels = new ArrayList<JTabFirePanel>(10);
    private JTabbedPane tabbedPane = null;
    public JSplitPane bottomSplitPane = null;
    public JSplitPane bottomLogSplitPane = null;

    public JMainPanel() {
        this.tabPanels.add(new JTabPanelPWM());
        this.tabPanels.add(new JTabPanelSystem());
        this.tabPanels.add(new JTabPanelPins());
        this.tabPanels.add(new JTabPanelInput());
        this.tabPanels.add(new JTabPanelSTV());
        this.tabPanels.add(new JTabPanelPTC());
        this.tabPanels.add(new JTabPanelPTT());
        this.tabPanels.add(new JTabPanelVFC());
        this.tabPanels.add(new JTabPanelMAL());
        this.tabPanels.add(new JTabPanelLPM());
        this.tabPanels.add(new JTabPanelGraphs());
        this.tabPanels.add(new JTabPanelVariables());
        if (PulseFireUI.getInstance().getSettingBoolean(PulseFireUISettingKeys.SCOPE_ENABLE).booleanValue()) {
            this.tabPanels.add(new JTabPanelScope());
        }
        this.tabPanels.add(new JTabPanelSettings());
        JMainPanel main = this;
        main.setLayout(new BorderLayout());
        main.add((Component)this.createTop(), "First");
        main.add((Component)this.createContentSplit(), "Center");
    }

    private JPanel createTop() {
        JPanel top = new JPanel();
        top.setLayout(new GridLayout(1, 2));
        top.add(new JTopPanelSerial());
        top.add(new JTopPanelStatus());
        return top;
    }

    private JSplitPane createContentSplit() {
        JPanel sp0 = this.createCenterContent();
        JSplitPane sp1 = this.createBottomSplit();
        this.bottomSplitPane = new JSplitPane(0, sp0, sp1);
        this.bottomSplitPane.setOneTouchExpandable(true);
        this.bottomSplitPane.setResizeWeight(0.7);
        this.bottomSplitPane.setDividerLocation(PulseFireUI.getInstance().getSettingInteger(PulseFireUISettingKeys.UI_SPLIT_BOTTOM));
        sp0.setMinimumSize(new Dimension(100, 350));
        sp1.setMinimumSize(new Dimension(200, 150));
        return this.bottomSplitPane;
    }

    private JSplitPane createBottomSplit() {
        JPanel sp0 = this.createBottomConsole();
        JPanel sp1 = this.createBottomInfo();
        this.bottomLogSplitPane = new JSplitPane(1, sp0, sp1);
        this.bottomLogSplitPane.setOneTouchExpandable(true);
        this.bottomLogSplitPane.setResizeWeight(0.4);
        this.bottomLogSplitPane.setDividerLocation(PulseFireUI.getInstance().getSettingInteger(PulseFireUISettingKeys.UI_SPLIT_BOTTOM_LOG));
        sp0.setMinimumSize(new Dimension(200, 100));
        sp1.setMinimumSize(new Dimension(200, 100));
        return this.bottomLogSplitPane;
    }

    private JPanel createCenterContent() {
        JPanel center = new JPanel();
        center.setLayout(new GridLayout(1, 0));
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setFont(UIManager.getFont("TabbedPane.font"));
        this.tabbedPane.setBorder(BorderFactory.createEmptyBorder());
        for (JTabFirePanel panel : this.tabPanels) {
            JScrollPane scrollPane = new JScrollPane(panel.getJPanel());
            scrollPane.setHorizontalScrollBarPolicy(32);
            scrollPane.setVerticalScrollBarPolicy(22);
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            panel.setParentScrollPane(scrollPane);
            this.tabbedPane.addTab(panel.getTabName(), panel.getTabIcon(), scrollPane, panel.getTabTooltip());
        }
        this.tabbedPane.setEnabledAt(8, false);
        center.add(this.tabbedPane);
        return center;
    }

    private JPanel createBottomConsole() {
        return new JPanelConsole();
    }

    private JPanel createBottomInfo() {
        return new JPanelConsoleInfo();
    }
}

