/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.components;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class JIntegerTextField
extends JTextField {
    private static final long serialVersionUID = 2632092178694978804L;

    public JIntegerTextField(int defval, int size) {
        super("" + defval, size);
    }

    @Override
    protected Document createDefaultModel() {
        return new DigitTextDocument();
    }

    @Override
    public boolean isValid() {
        if (!this.isShowing()) {
            return true;
        }
        if (this.getText() == null) {
            return true;
        }
        for (int i = 0; i < this.getText().length(); ++i) {
            char c = this.getText().charAt(i);
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public int getValue() {
        try {
            return Integer.parseInt(this.getText());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    class DigitTextDocument
    extends PlainDocument {
        private static final long serialVersionUID = 388982958009442073L;

        DigitTextDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (Character.isDigit(c)) continue;
                return;
            }
            super.insertString(offs, str, a);
        }
    }
}

