/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.flash.avrdude;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.nongnu.pulsefire.device.flash.AbstractFlashProgramController;
import org.nongnu.pulsefire.device.flash.FlashControllerConfig;
import org.nongnu.pulsefire.device.flash.FlashException;
import org.nongnu.pulsefire.device.flash.FlashHexReader;

public class AvrdudeController
extends AbstractFlashProgramController {
    @Override
    public void flash(FlashControllerConfig conf) throws IOException, FlashException {
        if (conf.getNativeFlashCmd() == null) {
            throw new FlashException("Can't flash with null nativeFlashCmd in config.");
        }
        if (conf.getNativeFlashCmd().isEmpty()) {
            throw new FlashException("Can't flash with empty nativeFlashCmd in config.");
        }
        File nativeCmd = new File(conf.getNativeFlashCmd());
        if (!nativeCmd.canExecute()) {
            throw new FlashException("Can't execute the nativeFlashCmd in config.");
        }
        this.progress = 1;
        ArrayList<String> cmd = new ArrayList<String>(15);
        cmd.add(nativeCmd.getAbsolutePath());
        String chipId = null;
        if (conf.getDeviceSignature() == 2003979) {
            chipId = "m168p";
        } else if (conf.getDeviceSignature() == 2004239) {
            chipId = "m328p";
        } else if (conf.getDeviceSignature() == 2004739) {
            chipId = "m1280";
        } else if (conf.getDeviceSignature() == 2004993) {
            chipId = "m2560";
        } else {
            throw new FlashException("unknown device id in conf: " + conf.getDeviceSignature());
        }
        cmd.add("-p");
        cmd.add(chipId);
        cmd.add("-P");
        cmd.add(conf.getPort());
        cmd.add("-c");
        cmd.add(conf.getPortProtocol());
        if (conf.isLogDebug()) {
            cmd.add("-v");
            cmd.add("-v");
        }
        if (!conf.isFlashVerify()) {
            cmd.add("-V");
        }
        if (conf.getNativeFlashConfig() != null && !conf.getNativeFlashConfig().isEmpty()) {
            cmd.add("-C");
            cmd.add(conf.getNativeFlashConfig());
        }
        File tmp = File.createTempFile("pulsefire-", ".hex");
        tmp.deleteOnExit();
        FlashHexReader hex = new FlashHexReader();
        hex.writeHexData(conf.getFlashData(), new FileOutputStream(tmp));
        cmd.add("-U");
        cmd.add("flash:w:" + tmp.getAbsolutePath());
        StringBuilder buf = new StringBuilder(200);
        for (String c : cmd) {
            buf.append(c);
            buf.append(' ');
        }
        this.logMessage("Exec: " + buf.toString());
        this.progress = 2;
        ProcessBuilder builder = new ProcessBuilder(cmd);
        builder.redirectErrorStream(true);
        Process process = builder.start();
        InputStream stdout = process.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stdout));
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.contains("device initialized")) {
                this.progress = 10;
            }
            if (line.contains("writing")) {
                this.progress = 50;
            }
            if (line.contains("Thank you")) {
                this.progress = 90;
            }
            this.logMessage(line);
        }
        this.progress = 100;
        this.logMessage("Avrdude is done.");
    }
}

