/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.nongnu.pulsefire.device.DeviceConnectListener;
import org.nongnu.pulsefire.device.DeviceData;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.device.ui.PulseFireUISettingKeys;
import org.nongnu.pulsefire.device.ui.PulseFireUISettingListener;
import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandName;

public class PulseFireDataLogManager {
    private Logger logger = Logger.getLogger(PulseFireDataLogManager.class.getName());
    private String lineSeparator = System.getProperty("line.separator");
    private LogDataWriter logDataWriter0 = null;
    private LogDataWriter logDataWriter1 = null;
    private LogDataWriter logDataWriter2 = null;

    public void start() {
        this.logDataWriter0 = new LogDataWriter(0);
        this.logDataWriter1 = new LogDataWriter(1);
        this.logDataWriter2 = new LogDataWriter(2);
        Thread t0 = new Thread(this.logDataWriter0);
        t0.setName(this.logDataWriter0.getClass().getSimpleName());
        t0.start();
        Thread t1 = new Thread(this.logDataWriter1);
        t1.setName(this.logDataWriter1.getClass().getSimpleName());
        t1.start();
        Thread t2 = new Thread(this.logDataWriter2);
        t2.setName(this.logDataWriter2.getClass().getSimpleName());
        t2.start();
    }

    public void stop() {
        if (this.logDataWriter0 != null) {
            this.logDataWriter0.shutdown();
        }
        if (this.logDataWriter1 != null) {
            this.logDataWriter1.shutdown();
        }
        if (this.logDataWriter2 != null) {
            this.logDataWriter2.shutdown();
        }
    }

    class LogDataWriter
    implements Runnable,
    DeviceConnectListener,
    PulseFireUISettingListener {
        private int loggerIndex = 0;
        private volatile boolean connected = false;
        private volatile boolean run = true;
        private volatile boolean logEnable = false;
        private volatile boolean logTimeStamp = true;
        private volatile String logFileName = null;
        private volatile String logPath = null;
        private volatile int logSpeed = 60000;
        private volatile List<CommandName> logFields = null;
        private volatile File writerFile = null;
        private volatile boolean writerStart = false;
        private volatile boolean writerStop = false;
        private volatile DateFormat logTimeFormat = null;
        private volatile DateFormat fileTimeFormat = null;
        private volatile long recordCount = 0L;
        private static final char FIELD_SEPERATOR = ',';
        private static final char FIELD_QUOTE = '\"';
        private static final char FIELD_SPACE = ' ';

        public LogDataWriter(int loggerIndexId) {
            this.loggerIndex = loggerIndexId;
            this.logTimeFormat = new SimpleDateFormat("HH:mm:ss-dd/MM/yyyy");
            this.fileTimeFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
            PulseFireUI.getInstance().getDeviceManager().addDeviceConnectListener((DeviceConnectListener)this);
            String logId = "LOG" + this.loggerIndex + "_";
            PulseFireUI.getInstance().getSettingsManager().addSettingListener(PulseFireUISettingKeys.valueOf(logId + "ENABLE"), this);
            PulseFireUI.getInstance().getSettingsManager().addSettingListener(PulseFireUISettingKeys.valueOf(logId + "TIMESTAMP"), this);
            PulseFireUI.getInstance().getSettingsManager().addSettingListener(PulseFireUISettingKeys.valueOf(logId + "FILENAME"), this);
            PulseFireUI.getInstance().getSettingsManager().addSettingListener(PulseFireUISettingKeys.valueOf(logId + "PATH"), this);
            PulseFireUI.getInstance().getSettingsManager().addSettingListener(PulseFireUISettingKeys.valueOf(logId + "SPEED"), this);
            PulseFireUI.getInstance().getSettingsManager().addSettingListener(PulseFireUISettingKeys.valueOf(logId + "FIELDS"), this);
            this.updateFields();
        }

        public void updateFields() {
            String logId = "LOG" + this.loggerIndex + "_";
            this.logEnable = PulseFireUI.getInstance().getSettingsManager().getSettingBoolean(PulseFireUISettingKeys.valueOf(logId + "ENABLE"));
            this.logTimeStamp = PulseFireUI.getInstance().getSettingsManager().getSettingBoolean(PulseFireUISettingKeys.valueOf(logId + "TIMESTAMP"));
            this.logFileName = PulseFireUI.getInstance().getSettingsManager().getSettingString(PulseFireUISettingKeys.valueOf(logId + "FILENAME"));
            this.logPath = PulseFireUI.getInstance().getSettingsManager().getSettingString(PulseFireUISettingKeys.valueOf(logId + "PATH"));
            this.logSpeed = PulseFireUI.getInstance().getSettingsManager().getSettingInteger(PulseFireUISettingKeys.valueOf(logId + "SPEED"));
            String logFieldStr = PulseFireUI.getInstance().getSettingsManager().getSettingString(PulseFireUISettingKeys.valueOf(logId + "FIELDS"));
            this.logFields = CommandName.decodeCommandList((String)logFieldStr);
            if (this.logSpeed < 1000) {
                this.logSpeed = 1000;
            }
        }

        @Override
        public void run() {
            try {
                while (this.run) {
                    if (!this.writerStart) {
                        Thread.sleep(500L);
                        continue;
                    }
                    this.writerStart = false;
                    Writer writer = this.startWriter();
                    if (writer == null) continue;
                    this.writeHeader(writer);
                    while (!this.writerStop) {
                        this.writeLine(writer);
                        for (int i = 0; !this.writerStop && i < this.logSpeed / 1000; ++i) {
                            Thread.sleep(1000L);
                        }
                    }
                    this.writerStop = false;
                    this.stopWriter(writer);
                }
            }
            catch (Exception e) {
                PulseFireDataLogManager.this.logger.log(Level.WARNING, e.getMessage(), e);
            }
        }

        private Writer startWriter() {
            if (!this.logEnable) {
                return null;
            }
            if (this.logFields.isEmpty()) {
                return null;
            }
            if (this.logFileName == null) {
                return null;
            }
            if (this.logFileName.isEmpty()) {
                return null;
            }
            if (this.logPath == null) {
                return null;
            }
            if (this.logPath.isEmpty()) {
                return null;
            }
            File realPath = new File(this.logPath);
            if (!realPath.exists()) {
                return null;
            }
            if (realPath.isFile()) {
                return null;
            }
            StringBuilder buf = new StringBuilder(100);
            buf.append(realPath.getAbsolutePath());
            buf.append(File.separator);
            buf.append(this.logFileName);
            if (this.logTimeStamp) {
                buf.append("-");
                buf.append(this.fileTimeFormat.format(new Date()));
            }
            buf.append(".log");
            this.writerFile = new File(buf.toString());
            try {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.writerFile, true), Charset.forName("UTF-8"));
                PulseFireDataLogManager.this.logger.info("Opening log file: " + this.writerFile.getAbsolutePath());
                return writer;
            }
            catch (Exception e) {
                PulseFireDataLogManager.this.logger.log(Level.WARNING, "Error while creating writer for file: " + this.writerFile.getAbsolutePath(), e);
                return null;
            }
        }

        private void stopWriter(Writer writer) {
            try {
                PulseFireDataLogManager.this.logger.info(" Closing log file: " + this.writerFile.getAbsolutePath() + " records: " + this.recordCount);
                this.recordCount = 0L;
                this.writerFile = null;
                writer.flush();
                writer.close();
            }
            catch (Exception e) {
                PulseFireDataLogManager.this.logger.log(Level.WARNING, "Error while closing writer: " + e.getMessage(), e);
            }
        }

        private void writeLine(Writer out) throws IOException {
            DeviceData devData = PulseFireUI.getInstance().getDeviceData();
            long time = System.currentTimeMillis();
            out.append('\"');
            out.append(Long.toString(time));
            out.append('\"');
            out.append(',');
            out.append('\"');
            out.append(this.logTimeFormat.format(time));
            out.append('\"');
            out.append(',');
            out.append('\"');
            for (int f = 0; f < this.logFields.size(); ++f) {
                CommandName cn = this.logFields.get(f);
                if (cn.isIndexedA()) {
                    for (int i = 0; i < cn.getMaxIndexA(); ++i) {
                        Command cmd = devData.getDeviceParameterIndexed(cn, Integer.valueOf(i));
                        if (cmd != null) {
                            if (cn.isIndexedB()) {
                                out.append(cmd.getArgu0());
                                if (cmd.getArgu1() != null) {
                                    out.append(' ');
                                    out.append(cmd.getArgu1());
                                }
                                if (cmd.getArgu2() != null) {
                                    out.append(' ');
                                    out.append(cmd.getArgu2());
                                }
                                if (cmd.getArgu3() != null) {
                                    out.append(' ');
                                    out.append(cmd.getArgu3());
                                }
                                if (cmd.getArgu4() != null) {
                                    out.append(' ');
                                    out.append(cmd.getArgu4());
                                }
                                if (cmd.getArgu5() != null) {
                                    out.append(' ');
                                    out.append(cmd.getArgu5());
                                }
                                if (cmd.getArgu6() != null) {
                                    out.append(' ');
                                    out.append(cmd.getArgu6());
                                }
                                if (cmd.getArgu7() != null) {
                                    out.append(' ');
                                    out.append(cmd.getArgu7());
                                }
                            } else {
                                out.append(cmd.getArgu0());
                            }
                        } else {
                            out.append(' ');
                        }
                        if (i >= cn.getMaxIndexA() - 1) continue;
                        out.append('\"');
                        out.append(',');
                        out.append('\"');
                    }
                } else {
                    Command cmd = devData.getDeviceParameter(cn);
                    if (cmd != null) {
                        out.append(cmd.getArgu0());
                    } else {
                        out.append(' ');
                    }
                }
                if (f >= this.logFields.size() - 1) continue;
                out.append('\"');
                out.append(',');
                out.append('\"');
            }
            out.append('\"');
            out.append(PulseFireDataLogManager.this.lineSeparator);
            out.flush();
            ++this.recordCount;
        }

        private void writeHeader(Writer out) throws IOException {
            out.append('#');
            out.append("epoch,time,");
            for (int f = 0; f < this.logFields.size(); ++f) {
                CommandName cn = this.logFields.get(f);
                if (cn.isIndexedA()) {
                    for (int i = 0; i < cn.getMaxIndexA(); ++i) {
                        out.append(cn.name());
                        out.append(Integer.toString(i));
                        if (i >= cn.getMaxIndexA() - 1) continue;
                        out.append(',');
                    }
                } else {
                    out.append(cn.name());
                }
                if (f >= this.logFields.size() - 1) continue;
                out.append(',');
            }
            out.append(PulseFireDataLogManager.this.lineSeparator);
            out.flush();
        }

        public void shutdown() {
            this.writerStop = true;
            this.run = false;
        }

        public void deviceConnect() {
            this.writerStart = true;
            this.connected = true;
        }

        public void deviceDisconnect() {
            this.writerStop = true;
            this.connected = false;
        }

        @Override
        public void settingUpdated(PulseFireUISettingKeys key, String value) {
            this.updateFields();
            if (!this.connected) {
                return;
            }
            if (this.writerFile != null) {
                this.writerStop = true;
            }
            this.writerStart = true;
        }
    }
}

