/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui;

import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import org.nongnu.pulsefire.device.DeviceCommandListener;
import org.nongnu.pulsefire.device.DeviceData;
import org.nongnu.pulsefire.device.DeviceWireManager;
import org.nongnu.pulsefire.device.ui.JComponentFactory;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.device.ui.SpringLayoutGrid;
import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandName;

public class JTopPanelStatus
extends JPanel
implements DeviceCommandListener {
    private static final long serialVersionUID = 94571180445561814L;
    private JLabel adcLabel = null;
    private JLabel adc2Label = null;
    private JLabel dicLabel = null;
    private JLabel docLabel = null;

    public JTopPanelStatus() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridLayout(1, 0));
        JPanel borderPanel = JComponentFactory.createJFirePanel("Status");
        this.add(borderPanel);
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new SpringLayout());
        borderPanel.add(inputPanel);
        inputPanel.add(new JLabel("Analog-In:"));
        this.adcLabel = new JLabel();
        inputPanel.add(this.adcLabel);
        inputPanel.add(new JLabel("Analog-In:"));
        this.adc2Label = new JLabel();
        inputPanel.add(this.adc2Label);
        inputPanel.add(new JLabel("Digital-In:"));
        this.dicLabel = new JLabel();
        inputPanel.add(this.dicLabel);
        inputPanel.add(new JLabel("Digital-Out:"));
        this.docLabel = new JLabel();
        inputPanel.add(this.docLabel);
        SpringLayoutGrid.makeCompactGrid(inputPanel, 4, 2);
        DeviceWireManager deviceManager = PulseFireUI.getInstance().getDeviceManager();
        deviceManager.addDeviceCommandListener(CommandName.adc_value, (DeviceCommandListener)this);
        deviceManager.addDeviceCommandListener(CommandName.dic_value, (DeviceCommandListener)this);
        deviceManager.addDeviceCommandListener(CommandName.doc_port, (DeviceCommandListener)this);
    }

    public void commandReceived(Command command) {
        int i;
        StringBuilder buf;
        DeviceData deviceData = PulseFireUI.getInstance().getDeviceManager().getDeviceData();
        if (command.getCommandName().equals((Object)CommandName.adc_value)) {
            String adcValue;
            Command cmd;
            int i2;
            buf = new StringBuilder(100);
            int s = CommandName.adc_value.getMaxIndexA();
            if (s > 7) {
                s = 7;
            }
            for (i2 = s; i2 >= 0; --i2) {
                cmd = deviceData.getDeviceParameterIndexed(command, Integer.valueOf(i2));
                if (cmd == null) continue;
                buf.append('A');
                buf.append('0');
                buf.append(i2);
                buf.append(": ");
                adcValue = cmd.getArgu0();
                if (adcValue.length() == 3) {
                    buf.append('0');
                } else if (adcValue.length() == 2) {
                    buf.append("00");
                } else if (adcValue.length() == 1) {
                    buf.append("000");
                }
                buf.append(adcValue);
                buf.append("  ");
            }
            this.adcLabel.setText(buf.toString());
            buf = new StringBuilder(100);
            if (CommandName.adc_value.getMaxIndexA() > 7) {
                for (i2 = CommandName.adc_value.getMaxIndexA(); i2 >= 8; --i2) {
                    cmd = deviceData.getDeviceParameterIndexed(command, Integer.valueOf(i2));
                    if (cmd == null) continue;
                    buf.append('A');
                    if (i2 < 10) {
                        buf.append('0');
                    }
                    buf.append(i2);
                    buf.append(": ");
                    adcValue = cmd.getArgu0();
                    if (adcValue.length() == 3) {
                        buf.append('0');
                    } else if (adcValue.length() == 2) {
                        buf.append("00");
                    } else if (adcValue.length() == 1) {
                        buf.append("000");
                    }
                    buf.append(adcValue);
                    buf.append("  ");
                }
            }
            this.adc2Label.setText(buf.toString());
        }
        if (command.getCommandName().equals((Object)CommandName.dic_value)) {
            buf = new StringBuilder(100);
            buf.append("0b");
            for (i = 15; i >= 0; --i) {
                int value = new Integer(command.getArgu0());
                int result = value >> i & 1;
                buf.append(result);
            }
            buf.append(" (15-0)");
            this.dicLabel.setText(buf.toString());
        }
        if (command.getCommandName().equals((Object)CommandName.doc_port)) {
            buf = new StringBuilder(100);
            buf.append("0b");
            for (i = 15; i >= 0; --i) {
                Command cmd = deviceData.getDeviceParameterIndexed(command, Integer.valueOf(i));
                if (cmd == null) continue;
                buf.append(cmd.getArgu0());
            }
            buf.append(" (15-0)");
            this.docLabel.setText(buf.toString());
        }
    }
}

