/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.flash.avr;

import java.io.IOException;
import java.util.ArrayList;
import org.nongnu.pulsefire.device.flash.FlashControllerConfig;
import org.nongnu.pulsefire.device.flash.FlashException;
import org.nongnu.pulsefire.device.flash.avr.AbstractStk500Controller;
import org.nongnu.pulsefire.device.flash.avr.FlashCommandToken;
import org.nongnu.pulsefire.device.flash.avr.FlashMessage;
import org.nongnu.pulsefire.device.flash.avr.Stk500Command;

public class Stk500Controller
extends AbstractStk500Controller {
    private boolean logDebug = false;

    @Override
    public void prepareMessagePrefix(FlashMessage msg, FlashCommandToken command) {
        msg.addRequestCommand(command);
    }

    @Override
    public void prepareMessagePostfix(FlashMessage msg, FlashCommandToken command) {
        msg.addRequestCommand(Stk500Command.CRC_EOP);
    }

    @Override
    public FlashMessage sendFlashMessage(FlashMessage message) throws IOException {
        if (message == null) {
            throw new NullPointerException("Can't send null message");
        }
        if (message.getRequest().isEmpty()) {
            throw new IllegalArgumentException("Can't send empty message");
        }
        StringBuilder buf = new StringBuilder(30);
        for (Integer data : message.getRequest()) {
            this.output.write(data);
            this.output.flush();
            String hex = Integer.toHexString(data);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            if (hex.startsWith("ffffff")) {
                hex = hex.substring(6);
            }
            buf.append(hex);
        }
        this.output.flush();
        if (this.logDebug) {
            this.logMessage("Send data: " + buf + " (" + Stk500Command.valueOfToken(message.getRequest().get(0)) + ")");
        }
        try {
            Thread.sleep(15L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        int timeout = 500;
        while (this.input.available() == 0) {
            if (--timeout == 0) {
                throw new IOException("timeout on read.");
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
        int responseSize = 2;
        if (message.getRequest().get(0) == Stk500Command.STK_GET_PARAMETER.getToken()) {
            responseSize = 3;
        }
        if (message.getRequest().get(0) == Stk500Command.STK_UNIVERSAL.getToken()) {
            responseSize = 3;
        }
        if (message.getRequest().get(0) == Stk500Command.STK_READ_SIGN.getToken()) {
            responseSize = 4;
        }
        if (message.getRequest().get(0) == Stk500Command.STK_READ_PAGE.getToken()) {
            responseSize = 130;
        }
        buf = new StringBuilder(30);
        for (int i = 0; i < responseSize; ++i) {
            timeout = 500;
            while (this.input.available() == 0) {
                if (--timeout == 0) {
                    throw new IOException("timeout on read.");
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {}
            }
            int data = this.input.read();
            message.getResponse().add(data);
            String hex = Integer.toHexString(data);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            if (hex.startsWith("ffffff")) {
                hex = hex.substring(6);
            }
            buf.append(hex);
        }
        if (this.logDebug) {
            this.logMessage("Read data: " + buf);
        }
        return message;
    }

    @Override
    protected void flashSafe(FlashControllerConfig flashControllerConfig) throws IOException, FlashException {
        if (flashControllerConfig == null) {
            throw new FlashException("Can't flash with null config.");
        }
        flashControllerConfig.verifyConfig();
        this.logConfig(flashControllerConfig);
        this.connectPort(flashControllerConfig);
        this.logDebug = flashControllerConfig.isLogDebug();
        if (this.output == null) {
            return;
        }
        this.progress = 1;
        this.rebootDevice();
        this.progress = 2;
        for (int i = 0; i < 5; ++i) {
            this.doFlashCommand(Stk500Command.STK_GET_SYNC, new Integer[0]);
        }
        this.progress = 3;
        FlashMessage msg = this.doFlashCommand(Stk500Command.STK_GET_SYNC, new Integer[0]);
        if (msg.getResponse().size() != 2) {
            throw new FlashException("not synced got !=2 bytes: " + msg.getResponse().size());
        }
        if (msg.getResponse().get(0) != Stk500Command.STK_INSYNC.getToken()) {
            throw new FlashException("not in sync; got: " + msg.getResponse().get(0) + " hex: " + Integer.toHexString(msg.getResponse().get(0)) + " wanted: " + Integer.toHexString(Stk500Command.STK_INSYNC.getToken()));
        }
        if (msg.getResponse().get(1) != Stk500Command.STK_OK.getToken()) {
            throw new FlashException("not connected; got: " + msg.getResponse().get(1));
        }
        this.logMessage("Synced communication.");
        this.progress = 6;
        this.logMessage("Programmer: Arduino");
        FlashMessage versionHw = this.doFlashCommand(Stk500Command.STK_GET_PARAMETER, 128);
        FlashMessage versionSwMajor = this.doFlashCommand(Stk500Command.STK_GET_PARAMETER, 129);
        FlashMessage versionSwMinor = this.doFlashCommand(Stk500Command.STK_GET_PARAMETER, 130);
        this.logMessage("Hardware verion: " + versionHw.getResponse().get(1));
        this.logMessage("Firmware verion: " + versionSwMajor.getResponse().get(1) + "." + versionSwMinor.getResponse().get(1));
        FlashMessage vtarget = this.doFlashCommand(Stk500Command.STK_GET_PARAMETER, 132);
        FlashMessage varef = this.doFlashCommand(Stk500Command.STK_GET_PARAMETER, 133);
        FlashMessage osc0 = this.doFlashCommand(Stk500Command.STK_GET_PARAMETER, 134);
        FlashMessage osc1 = this.doFlashCommand(Stk500Command.STK_GET_PARAMETER, 135);
        FlashMessage sck = this.doFlashCommand(Stk500Command.STK_GET_PARAMETER, 137);
        double voltageTarget = new Double(vtarget.getResponse().get(1).intValue()) / 10.0;
        this.logMessage("Vtarget: " + voltageTarget);
        FlashMessage enterProg = this.doFlashCommand(Stk500Command.STK_ENTER_PROGMODE, new Integer[0]);
        this.logMessage("AVR device initialized");
        FlashMessage deviceSign = this.doFlashCommand(Stk500Command.STK_READ_SIGN, new Integer[0]);
        int deviceId = deviceSign.getResponse().get(3) + (deviceSign.getResponse().get(2) << 8) + (deviceSign.getResponse().get(1) << 16);
        this.logMessage("Device signature: 0x" + Integer.toHexString(deviceId));
        if (flashControllerConfig.getDeviceSignature() > 0 && flashControllerConfig.getDeviceSignature() != deviceId) {
            throw new FlashException("Device signature is different: " + Integer.toHexString(deviceId) + " expected: " + Integer.toHexString(flashControllerConfig.getDeviceSignature()));
        }
        FlashMessage lFuse0 = this.doFlashCommand(Stk500Command.STK_UNIVERSAL, 80, 0, 0, 0);
        FlashMessage lFuse1 = this.doFlashCommand(Stk500Command.STK_UNIVERSAL, 80, 0, 0, 0);
        FlashMessage lFuse2 = this.doFlashCommand(Stk500Command.STK_UNIVERSAL, 80, 0, 0, 0);
        this.logMessage("lfuse value: 0x" + Integer.toHexString(lFuse2.getResponse().get(1)));
        FlashMessage hFuse0 = this.doFlashCommand(Stk500Command.STK_UNIVERSAL, 88, 8, 0, 0);
        FlashMessage hFuse1 = this.doFlashCommand(Stk500Command.STK_UNIVERSAL, 88, 8, 0, 0);
        FlashMessage hFuse2 = this.doFlashCommand(Stk500Command.STK_UNIVERSAL, 88, 8, 0, 0);
        this.logMessage("hfuse value: 0x" + Integer.toHexString(hFuse2.getResponse().get(1)));
        FlashMessage eFuse0 = this.doFlashCommand(Stk500Command.STK_UNIVERSAL, 80, 8, 0, 0);
        FlashMessage eFuse1 = this.doFlashCommand(Stk500Command.STK_UNIVERSAL, 80, 8, 0, 0);
        FlashMessage eFuse2 = this.doFlashCommand(Stk500Command.STK_UNIVERSAL, 80, 8, 0, 0);
        this.logMessage("efuse value: 0x" + Integer.toHexString(eFuse2.getResponse().get(1) & 7));
        if (flashControllerConfig.isFlashErase()) {
            this.logMessage("Erase flash memery.");
            FlashMessage eraseFlash0 = this.doFlashCommand(Stk500Command.STK_UNIVERSAL, 160, 3, 252, 0);
            FlashMessage eraseFlash1 = this.doFlashCommand(Stk500Command.STK_UNIVERSAL, 160, 3, 253, 0);
            FlashMessage eraseFlash2 = this.doFlashCommand(Stk500Command.STK_UNIVERSAL, 160, 3, 254, 0);
            FlashMessage eraseFlash3 = this.doFlashCommand(Stk500Command.STK_UNIVERSAL, 160, 3, 255, 0);
        }
        this.progress = 10;
        byte[] dataBytes = flashControllerConfig.getFlashData();
        int pageSize = 128;
        int pages = dataBytes.length / pageSize;
        this.logMessage("Start flashing.");
        float flashTotalPercentage = 90.0f;
        if (flashControllerConfig.isFlashVerify()) {
            flashTotalPercentage = 80.0f;
        }
        for (int i = 0; i <= pages; ++i) {
            this.progress = new Float(flashTotalPercentage / (float)pages * (float)i).intValue() + 10;
            int address = i * pageSize / 2;
            if (flashControllerConfig.isLogDebug()) {
                this.logMessage("Set address: " + Integer.toHexString(address));
            }
            this.doFlashCommand(Stk500Command.STK_LOAD_ADDRESS, address, address >> 8);
            FlashMessage flash = new FlashMessage();
            this.prepareMessagePrefix(flash, Stk500Command.STK_PROG_PAGE);
            flash.getRequest().add(0);
            flash.getRequest().add(pageSize);
            flash.getRequest().add(70);
            for (int d = 0; d < pageSize; ++d) {
                int byteData = 0;
                int addr = i * pageSize;
                if (addr + d < dataBytes.length) {
                    byteData = dataBytes[addr + d];
                }
                flash.getRequest().add(byteData);
            }
            this.prepareMessagePostfix(flash, Stk500Command.STK_PROG_PAGE);
            flash = this.sendFlashMessage(flash);
        }
        this.logMessage("Flashing is done.");
        if (flashControllerConfig.isFlashVerify()) {
            this.logMessage("Reading flash for verify.");
            ArrayList<Integer> readBytes = new ArrayList<Integer>(flashControllerConfig.getFlashData().length);
            for (int i = 0; i <= pages; ++i) {
                this.progress = new Float(10.0f / (float)pages * (float)i).intValue() + 90;
                int address = i * pageSize / 2;
                if (flashControllerConfig.isLogDebug()) {
                    this.logMessage("Set address: " + Integer.toHexString(address));
                }
                this.doFlashCommand(Stk500Command.STK_LOAD_ADDRESS, address, address >> 8);
                FlashMessage flash = new FlashMessage();
                this.prepareMessagePrefix(flash, Stk500Command.STK_READ_PAGE);
                flash.getRequest().add(0);
                flash.getRequest().add(pageSize);
                flash.getRequest().add(70);
                this.prepareMessagePostfix(flash, Stk500Command.STK_READ_PAGE);
                flash = this.sendFlashMessage(flash);
                for (int ii = 2; ii < flash.getResponse().size(); ++ii) {
                    Integer data = flash.getResponse().get(ii);
                    readBytes.add(data);
                }
            }
            this.logMessage("Verify flash data...");
            for (int ii = 0; ii < flashControllerConfig.getFlashData().length; ++ii) {
                byte burnData = flashControllerConfig.getFlashData()[ii];
                if (ii > readBytes.size()) {
                    throw new FlashException("Missing backread bytes to verify");
                }
                byte readData = ((Integer)readBytes.get(ii)).byteValue();
                if (burnData == readData) continue;
                throw new FlashException("Mismatch on address: " + Integer.toHexString(ii) + " expected: " + Integer.toHexString(burnData) + " got: " + Integer.toHexString(readData));
            }
            this.logMessage("Verified " + readBytes.size() + " bytes flash oke.");
        }
        this.progress = 100;
    }
}

