/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SpringLayout;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.nongnu.pulsefire.device.flash.FlashControllerConfig;
import org.nongnu.pulsefire.device.flash.FlashHexReader;
import org.nongnu.pulsefire.device.flash.FlashLogListener;
import org.nongnu.pulsefire.device.flash.FlashManager;
import org.nongnu.pulsefire.device.flash.FlashProgramController;
import org.nongnu.pulsefire.device.ui.DevicePortsComboBoxModel;
import org.nongnu.pulsefire.device.ui.JComponentFactory;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.device.ui.PulseFireUISettingKeys;
import org.nongnu.pulsefire.device.ui.SpringLayoutGrid;

public class JFlashDialog
extends JDialog
implements ActionListener,
ListSelectionListener,
FlashLogListener,
MouseListener {
    private static final long serialVersionUID = -7552916322807635756L;
    private Logger logger = null;
    private FlashControllerConfig flashConfig = null;
    private volatile FlashProgramController flashProgramController = null;
    private JComboBox mcuTypeBox = null;
    private JComboBox mcuSpeedBox = null;
    private JPanel filterItemPanel = null;
    private Map<String, FilterItem> filterItems = new HashMap<String, FilterItem>(10);
    private JComboBox portsComboBox = null;
    private JComboBox progComboBox = null;
    private JCheckBox progVerboseBox = null;
    private JCheckBox progVerifyBox = null;
    private JProgressBar flashProgressBar = null;
    private JTextArea flashLog = null;
    private DateFormat flashLogTimeFormat = null;
    private JButton closeButton = null;
    private JButton flashButton = null;
    private JButton saveButton = null;
    private DeviceImagesTableModel tableModel = null;
    private JTable table = null;
    private JLabel burnName = null;
    private JLabel burnDeviceId = null;
    private String nativeFlashCmd = null;
    private String nativeFlashConfig = null;
    private String[] columnNames = new String[]{"name", "speed", "EXT_OUT", "EXT_O16", "EXT_LCD", "EXT_DIC", "EXT_DOC", "PWM", "LCD", "LPM", "PPM", "ADC", "DIC", "DOC", "DEV", "PTC", "PTT", "STV", "VFC", "SWC", "MAL", "GLCD", "CIT", "CIP"};

    public JFlashDialog(Frame aFrame) {
        super(aFrame, true);
        this.logger = Logger.getLogger(JFlashDialog.class.getName());
        this.nativeFlashCmd = PulseFireUI.getInstance().getSettingsManager().getSettingString(PulseFireUISettingKeys.AVRDUDE_CMD);
        this.nativeFlashConfig = PulseFireUI.getInstance().getSettingsManager().getSettingString(PulseFireUISettingKeys.AVRDUDE_CONFIG);
        this.setTitle("Flash chip firmware");
        this.setMinimumSize(new Dimension(640, 480));
        this.setPreferredSize(new Dimension(999, 666));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                JFlashDialog.this.clearAndHide();
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this.createPanelTop(), "North");
        mainPanel.add((Component)this.createPanelCenter(), "Center");
        mainPanel.add((Component)this.createPanelBottom(), "South");
        this.getContentPane().add(mainPanel);
        this.pack();
        this.setLocationRelativeTo(aFrame);
    }

    private JPanel createPanelTop() {
        JPanel filterHeaderPanel = JComponentFactory.createJFirePanel("Filter options");
        JPanel tableOption = new JPanel();
        tableOption.setLayout(new SpringLayout());
        JLabel mcuText = new JLabel("mcu:");
        tableOption.add(mcuText);
        this.mcuTypeBox = JComponentFactory.createSettingsJComboBox(PulseFireUISettingKeys.FLASH_MCU_TYPE, new String[]{"ALL", "atmega328p", "atmega168p", "atmega1280", "atmega2560"});
        this.mcuTypeBox.addActionListener(this);
        tableOption.add(this.mcuTypeBox);
        JLabel speedText = new JLabel("speed:");
        tableOption.add(speedText);
        this.mcuSpeedBox = JComponentFactory.createSettingsJComboBox(PulseFireUISettingKeys.FLASH_MCU_SPEED, new String[]{"ALL", "16Mhz", "20Mhz", "72Mhz", "720Mhz"});
        this.mcuSpeedBox.addActionListener(this);
        tableOption.add(this.mcuSpeedBox);
        SpringLayoutGrid.makeCompactGrid(tableOption, 2, 2);
        this.filterItemPanel = new JPanel();
        this.filterItemPanel.setLayout(new SpringLayout());
        filterHeaderPanel.add(tableOption);
        filterHeaderPanel.add(this.filterItemPanel);
        JPanel optionWrapPanel = new JPanel();
        optionWrapPanel.setLayout(new FlowLayout(0));
        optionWrapPanel.add(filterHeaderPanel);
        return optionWrapPanel;
    }

    private JScrollPane createPanelCenter() {
        this.tableModel = new DeviceImagesTableModel();
        this.table = new JTable(this.tableModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().setResizingAllowed(true);
        this.table.setAutoResizeMode(0);
        this.table.setFillsViewportHeight(true);
        this.table.setShowHorizontalLines(true);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.setRowMargin(2);
        this.table.setRowHeight(26);
        this.table.getTableHeader().addMouseListener(this);
        TableColumn nameColumn = this.table.getColumnModel().getColumn(0);
        nameColumn.setPreferredWidth(150);
        TableColumn speedColumn = this.table.getColumnModel().getColumn(1);
        speedColumn.setPreferredWidth(130);
        ToolTipManager.sharedInstance().unregisterComponent(this.table);
        ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
        JScrollPane scroll = new JScrollPane(this.table);
        return scroll;
    }

    private JPanel createPanelBottom() {
        JPanel burnPanel = JComponentFactory.createJFirePanel("Burn");
        burnPanel.setLayout(new FlowLayout(0));
        JPanel burnOptionPanel = new JPanel();
        burnOptionPanel.setLayout(new SpringLayout());
        burnOptionPanel.add(new JLabel("Name:"));
        this.burnName = new JLabel();
        burnOptionPanel.add(this.burnName);
        burnOptionPanel.add(new JLabel("DeviceId:"));
        this.burnDeviceId = new JLabel();
        burnOptionPanel.add(this.burnDeviceId);
        burnOptionPanel.add(new JLabel("Port:"));
        DevicePortsComboBoxModel portModel = new DevicePortsComboBoxModel();
        this.portsComboBox = new JComboBox(portModel);
        this.portsComboBox.addPopupMenuListener(portModel);
        burnOptionPanel.add(this.portsComboBox);
        burnOptionPanel.add(new JLabel("Programer:"));
        this.progComboBox = this.nativeFlashCmd != null && !this.nativeFlashCmd.isEmpty() && this.nativeFlashConfig != null && !this.nativeFlashConfig.isEmpty() ? new JComboBox<String>(new String[]{"arduino", "stk500v2", "native-arduino", "native-stk500v1", "native-stk500v2"}) : new JComboBox<String>(new String[]{"arduino", "stk500v2"});
        burnOptionPanel.add(this.progComboBox);
        burnOptionPanel.add(new JLabel("logVerbose:"));
        this.progVerboseBox = new JCheckBox();
        burnOptionPanel.add(this.progVerboseBox);
        burnOptionPanel.add(new JLabel("flashVerify:"));
        this.progVerifyBox = new JCheckBox();
        burnOptionPanel.add(this.progVerifyBox);
        SpringLayoutGrid.makeCompactGrid(burnOptionPanel, 6, 2);
        burnPanel.add(burnOptionPanel);
        JPanel burnProgressPanel = new JPanel();
        burnProgressPanel.setLayout(new GridLayout(1, 1));
        burnProgressPanel.setBorder(BorderFactory.createEmptyBorder(6, 0, 12, 0));
        this.flashProgressBar = new JProgressBar();
        this.flashProgressBar.setStringPainted(true);
        burnProgressPanel.add(this.flashProgressBar);
        JPanel logPanel = JComponentFactory.createJFirePanel("Burn Log");
        this.flashLogTimeFormat = new SimpleDateFormat("HH:mm:ss");
        this.flashLog = new JTextArea(10, 50);
        this.flashLog.setMargin(new Insets(2, 2, 2, 2));
        this.flashLog.setAutoscrolls(true);
        this.flashLog.setEditable(false);
        JScrollPane consoleScrollPane = new JScrollPane(this.flashLog);
        consoleScrollPane.setHorizontalScrollBarPolicy(31);
        consoleScrollPane.setVerticalScrollBarPolicy(22);
        consoleScrollPane.getViewport().setOpaque(false);
        logPanel.add(consoleScrollPane);
        this.updateText("Ready to flash.");
        JPanel burnActionPanel = new JPanel();
        burnActionPanel.setBorder(BorderFactory.createEmptyBorder());
        burnActionPanel.setLayout(new FlowLayout(2));
        this.saveButton = new JButton("Export");
        this.saveButton.addActionListener(this);
        burnActionPanel.add(this.saveButton);
        this.flashButton = new JButton("Flash");
        this.flashButton.addActionListener(this);
        burnActionPanel.add(this.flashButton);
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(this);
        burnActionPanel.add(this.closeButton);
        JPanel burnWrapPanel = new JPanel();
        burnWrapPanel.setLayout(new BorderLayout());
        burnWrapPanel.add((Component)burnProgressPanel, "First");
        burnWrapPanel.add((Component)burnPanel, "Center");
        burnWrapPanel.add((Component)logPanel, "After");
        burnWrapPanel.add((Component)burnActionPanel, "Last");
        return burnWrapPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.closeButton) {
            this.clearAndHide();
            return;
        }
        if (e.getSource() == this.saveButton) {
            if (this.burnName.getText().isEmpty()) {
                return;
            }
            JFileChooser fileSelect = new JFileChooser();
            fileSelect.setSelectedFile(new File("pulsefire-" + this.burnName.getText() + ".hex"));
            int returnVal = fileSelect.showSaveDialog((JButton)e.getSource());
            if (returnVal == 0) {
                this.saveToFile(this.burnName.getText(), fileSelect.getSelectedFile());
            }
        }
        if (e.getSource() == this.flashButton) {
            if (this.burnName.getText().isEmpty()) {
                return;
            }
            String hexResource = "firmware/" + this.burnName.getText() + "/pulsefire.hex";
            this.logger.info("Start chip flash of: " + hexResource);
            byte[] flashData = null;
            try {
                flashData = new FlashHexReader().loadHex(hexResource);
            }
            catch (Exception hexException) {
                this.logger.log(Level.WARNING, hexException.getMessage(), hexException);
                JComponentFactory.showWarningDialog(this.getRootPane(), "Hex data error", "There has been an error in loading or parsing the flash hex data correctly.\nMessage: " + hexException.getMessage());
                return;
            }
            this.portsComboBox.setEnabled(false);
            this.progComboBox.setEnabled(false);
            this.progVerboseBox.setEnabled(false);
            this.progVerifyBox.setEnabled(false);
            this.flashButton.setEnabled(false);
            this.closeButton.setEnabled(false);
            this.table.setEnabled(false);
            if (this.flashLog.getText().length() > 32) {
                this.flashLog.setText("");
            }
            this.flashConfig = new FlashControllerConfig();
            this.flashConfig.setPort(this.portsComboBox.getSelectedItem().toString());
            this.flashConfig.setPortProtocol(this.progComboBox.getSelectedItem().toString());
            this.flashConfig.setLogDebug(this.progVerboseBox.isSelected());
            this.flashConfig.setFlashVerify(this.progVerifyBox.isSelected());
            this.flashConfig.setFlashData(flashData);
            String deviceId = this.burnDeviceId.getText();
            if (deviceId != null && !deviceId.isEmpty() && deviceId.startsWith("0x") && deviceId.length() > 2) {
                this.flashConfig.setDeviceSignature(Integer.parseInt(this.burnDeviceId.getText().substring(2), 16));
            }
            if (this.nativeFlashCmd != null && !this.nativeFlashCmd.isEmpty()) {
                this.flashConfig.setNativeFlashCmd(this.nativeFlashCmd);
            }
            if (this.nativeFlashConfig != null && !this.nativeFlashConfig.isEmpty()) {
                this.flashConfig.setNativeFlashConfig(this.nativeFlashConfig);
            }
            this.flashProgramController = FlashManager.createFlashController((FlashControllerConfig)this.flashConfig);
            FlashThread t = new FlashThread();
            t.start();
            ProgressThread p = new ProgressThread();
            p.start();
            return;
        }
        this.tableModel.refilterData();
    }

    private void saveToFile(String burnName, File file) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            InputStream is = cl.getResourceAsStream("firmware/" + burnName + "/pulsefire.hex");
            FileOutputStream os = new FileOutputStream(file);
            byte[] buf = new byte[4096];
            int cnt = is.read(buf);
            while (cnt > 0) {
                ((OutputStream)os).write(buf, 0, cnt);
                cnt = is.read(buf);
            }
            ((OutputStream)os).close();
            is.close();
        }
        catch (Exception saveException) {
            this.logger.log(Level.WARNING, saveException.getMessage(), saveException);
            JComponentFactory.showWarningDialog(this.getRootPane(), "Save file error", "There has been an error in saving the flash hex data correctly.\nMessage: " + saveException.getMessage());
            return;
        }
    }

    private void updateText(String data) {
        this.flashLog.append(this.flashLogTimeFormat.format(new Date()));
        this.flashLog.append(" # ");
        this.flashLog.append(data);
        this.flashLog.append("\n");
        this.flashLog.repaint();
        this.flashLog.setCaretPosition(this.flashLog.getText().length());
    }

    public void flashLogMessage(String message) {
        this.updateText(message);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.table.getSelectedRow() == -1) {
            return;
        }
        BuildOption option = this.tableModel.getBuildOptions().get(this.table.getSelectedRow());
        this.burnName.setText(option.name);
        if ("stk500v2".equals(option.ispProg)) {
            this.progComboBox.setSelectedIndex(1);
        } else {
            this.progComboBox.setSelectedIndex(0);
        }
        if (option.name.startsWith("atmega168p")) {
            this.burnDeviceId.setText("0x1e940b");
        } else if (option.name.startsWith("atmega328p")) {
            this.burnDeviceId.setText("0x1e950f");
        } else if (option.name.startsWith("atmega1280")) {
            this.burnDeviceId.setText("0x1e9703");
        } else if (option.name.startsWith("atmega2560")) {
            this.burnDeviceId.setText("0x1e9801");
        } else {
            this.burnDeviceId.setText("");
        }
    }

    public void clearAndHide() {
        this.setVisible(false);
    }

    public Collection<BuildOption> readBuildOptionsFile(File inputFile) throws IOException {
        return this.readBuildOptions(new FileInputStream(inputFile));
    }

    public Collection<BuildOption> readBuildOptionsResource(String inputResource) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        return this.readBuildOptions(cl.getResourceAsStream(inputResource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<BuildOption> readBuildOptions(InputStream input) throws IOException {
        if (input == null) {
            throw new NullPointerException("Can't read null inputstream.");
        }
        HashMap<String, BuildOption> result = new HashMap<String, BuildOption>(100);
        BufferedReader reader = null;
        try {
            reader = new LineNumberReader(new InputStreamReader(input, Charset.forName("UTF-8")));
            String line = null;
            while ((line = ((LineNumberReader)reader).readLine()) != null) {
                String[] lineOption;
                int idx;
                if (line.startsWith("#") || line.startsWith("//") || (idx = line.indexOf(58)) < 4) continue;
                if (line.contains("-isp:")) {
                    idx -= 4;
                }
                char buildNumber2 = line.charAt(idx - 1);
                char buildNumber1 = line.charAt(idx - 2);
                char buildNumber0 = line.charAt(idx - 3);
                if (!Character.isDigit(buildNumber2) || !Character.isDigit(buildNumber1) || !Character.isDigit(buildNumber0)) continue;
                String[] split = line.split(":");
                String buildName = split[0];
                BuildOption option = (BuildOption)result.get(buildName = buildName.replaceAll("-isp", ""));
                if (option == null) {
                    option = new BuildOption();
                    option.name = split[0];
                    result.put(option.name, option);
                }
                if ((lineOption = split[1].trim().split("=")).length < 2) continue;
                if (lineOption[0].startsWith("MCU")) {
                    option.mcu = lineOption[1].trim();
                    continue;
                }
                if (lineOption[0].startsWith("F_CPU")) {
                    option.speed = new Integer(lineOption[1].trim());
                    continue;
                }
                if (lineOption[0].startsWith("ISP_MCU")) {
                    option.ispMcu = lineOption[1].trim();
                    continue;
                }
                if (lineOption[0].startsWith("ISP_PROG")) {
                    option.ispProg = lineOption[1].trim();
                    continue;
                }
                if (!lineOption[0].startsWith("PFLAGS")) continue;
                String flag = lineOption[1].trim();
                if (flag.startsWith("-D_")) {
                    if (lineOption.length > 2) {
                        option.options.add(flag + "=" + lineOption[2]);
                        continue;
                    }
                    option.options.add(flag);
                    continue;
                }
                option.flags.add(flag);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (input != null) {
                input.close();
            }
        }
        this.logger.info("Loaded makefile with: " + result.size() + " builds.");
        return result.values();
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        int columnCount;
        FilterItem fi;
        int modelIndex;
        TableColumnModel colModel = this.table.getColumnModel();
        int columnIndex = colModel.getColumnIndexAtX(evt.getX());
        if (columnIndex < 0 | (modelIndex = this.table.convertColumnIndexToModel(columnIndex)) < 0) {
            return;
        }
        Rectangle headerPadding = this.table.getTableHeader().getHeaderRect(columnIndex);
        if (columnIndex == 0) {
            headerPadding.width -= 3;
        } else {
            headerPadding.grow(-3, 0);
        }
        if (!headerPadding.contains(evt.getX(), evt.getY())) {
            return;
        }
        if (modelIndex == 0) {
            return;
        }
        if (modelIndex == 1) {
            return;
        }
        String name = this.tableModel.getColumnName(modelIndex);
        if ("EXT_O16".equals(name)) {
            name = "EXT_OUT_16BIT";
        }
        if ("EXT_DIC".equals(name)) {
            name = "EXT_LCD_DIC";
        }
        if ("EXT_DOC".equals(name)) {
            name = "EXT_LCD_DOC";
        }
        if ((fi = this.filterItems.get(name)) == null) {
            fi = new FilterItem();
            fi.name = name;
            fi.checkBox = new JCheckBox();
            fi.checkBox.addActionListener(this);
            fi.checkBox.setSelected(true);
            fi.label = new JLabel(name);
            this.filterItems.put(name, fi);
        } else {
            fi.checkBox.removeActionListener(this);
            this.filterItems.remove(fi.name);
        }
        this.filterItemPanel.removeAll();
        for (FilterItem i : this.filterItems.values()) {
            this.filterItemPanel.add(i.label);
            this.filterItemPanel.add(i.checkBox);
        }
        int compomentCount = this.filterItems.size();
        int spaceSize = compomentCount / (columnCount = 2) * columnCount;
        if (spaceSize != compomentCount) {
            spaceSize += columnCount;
        }
        for (int i = compomentCount; i < spaceSize; ++i) {
            this.filterItemPanel.add(new JLabel(""));
            this.filterItemPanel.add(new JLabel(""));
        }
        SpringLayoutGrid.makeCompactGrid(this.filterItemPanel, 2, this.filterItemPanel.getComponentCount() / 2);
        this.filterItemPanel.revalidate();
        this.tableModel.refilterData();
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    public class BuildOption {
        public String name;
        public String mcu;
        public Integer speed;
        public String ispMcu;
        public String ispProg;
        public List<String> flags = new ArrayList<String>(20);
        public List<String> options = new ArrayList<String>(20);
    }

    public class DeviceImagesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -1432038909521987705L;
        private List<BuildOption> data = new ArrayList<BuildOption>(100);
        private List<BuildOption> dataFull = new ArrayList<BuildOption>(100);

        public DeviceImagesTableModel() {
            try {
                this.dataFull.addAll(JFlashDialog.this.readBuildOptionsResource("firmware/makefile"));
            }
            catch (Exception e) {
                JFlashDialog.this.logger.warning("Could not load resource makefile.");
            }
            this.refilterData();
        }

        public List<BuildOption> getBuildOptions() {
            return this.data;
        }

        public void refilterData() {
            this.data.clear();
            for (BuildOption option : this.dataFull) {
                String speedText;
                Integer speed;
                String mcyTypeText;
                if (option.name != null && option.name.startsWith("arm")) continue;
                boolean filter = false;
                for (FilterItem fi : JFlashDialog.this.filterItems.values()) {
                    boolean selected = fi.checkBox.isSelected();
                    boolean flag = this.checkFlag(option, fi.name);
                    if (selected && !flag) {
                        filter = true;
                        break;
                    }
                    if (selected || !flag) continue;
                    filter = true;
                    break;
                }
                if (filter || JFlashDialog.this.mcuTypeBox.getSelectedIndex() > 0 && !(mcyTypeText = JFlashDialog.this.mcuTypeBox.getSelectedItem().toString()).equals(option.mcu) || JFlashDialog.this.mcuSpeedBox.getSelectedIndex() > 0 && !(speed = new Integer((speedText = JFlashDialog.this.mcuSpeedBox.getSelectedItem().toString().replace("Mhz", "")) + "000000")).equals(option.speed)) continue;
                this.data.add(option);
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return JFlashDialog.this.columnNames.length;
        }

        @Override
        public String getColumnName(int col) {
            return JFlashDialog.this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            BuildOption option = this.data.get(row);
            switch (col) {
                default: {
                    return option.name;
                }
                case 1: {
                    return option.speed;
                }
                case 2: {
                    return this.checkFlag(option, "EXT_OUT");
                }
                case 3: {
                    return this.checkFlag(option, "EXT_OUT_16BIT");
                }
                case 4: {
                    return this.checkFlag(option, "EXT_LCD");
                }
                case 5: {
                    return this.checkFlag(option, "EXT_LCD_DIC");
                }
                case 6: {
                    return this.checkFlag(option, "EXT_LCD_DOC");
                }
                case 7: {
                    return this.checkFlag(option, "PWM");
                }
                case 8: {
                    return this.checkFlag(option, "LCD");
                }
                case 9: {
                    return this.checkFlag(option, "LPM");
                }
                case 10: {
                    return this.checkFlag(option, "PPM");
                }
                case 11: {
                    return this.checkFlag(option, "ADC");
                }
                case 12: {
                    return this.checkFlag(option, "DIC");
                }
                case 13: {
                    return this.checkFlag(option, "DOC");
                }
                case 14: {
                    return this.checkFlag(option, "DEV");
                }
                case 15: {
                    return this.checkFlag(option, "PTC");
                }
                case 16: {
                    return this.checkFlag(option, "PTT");
                }
                case 17: {
                    return this.checkFlag(option, "STV");
                }
                case 18: {
                    return this.checkFlag(option, "VFC");
                }
                case 19: {
                    return this.checkFlag(option, "SWC");
                }
                case 20: {
                    return this.checkFlag(option, "MAL");
                }
                case 21: {
                    return this.checkFlag(option, "GLCD");
                }
                case 22: {
                    return this.checkFlag(option, "CIT");
                }
                case 23: 
            }
            return this.checkFlag(option, "CIP");
        }

        private boolean checkFlag(BuildOption option, String checkFlag) {
            for (String flag : option.flags) {
                if (!flag.endsWith(checkFlag)) continue;
                return true;
            }
            return false;
        }
    }

    class ProgressThread
    extends Thread {
        ProgressThread() {
        }

        @Override
        public void run() {
            JFlashDialog.this.logger.fine("Start progress thread.");
            while (JFlashDialog.this.flashProgramController != null) {
                int progress = JFlashDialog.this.flashProgramController.getProgress();
                JFlashDialog.this.logger.finer("Flash progress: " + progress);
                JFlashDialog.this.flashProgressBar.getModel().setValue(progress);
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
            JFlashDialog.this.flashProgressBar.getModel().setValue(0);
            JFlashDialog.this.portsComboBox.setEnabled(true);
            JFlashDialog.this.progComboBox.setEnabled(true);
            JFlashDialog.this.progVerboseBox.setEnabled(true);
            JFlashDialog.this.progVerifyBox.setEnabled(true);
            JFlashDialog.this.flashButton.setEnabled(true);
            JFlashDialog.this.closeButton.setEnabled(true);
            JFlashDialog.this.table.setEnabled(true);
            JFlashDialog.this.logger.fine("Stopped progress thread.");
        }
    }

    class FlashThread
    extends Thread {
        FlashThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                JFlashDialog.this.logger.fine("Start flash thread.");
                JFlashDialog.this.flashProgramController.addFlashLogListener((FlashLogListener)JFlashDialog.this);
                JFlashDialog.this.flashProgramController.flash(JFlashDialog.this.flashConfig);
            }
            catch (Exception runException) {
                JFlashDialog.this.logger.log(Level.WARNING, runException.getMessage(), runException);
            }
            finally {
                JFlashDialog.this.flashProgramController.removeFlashLogListener((FlashLogListener)JFlashDialog.this);
                JFlashDialog.this.flashProgramController = null;
                JFlashDialog.this.logger.fine("Stopped flash thread.");
            }
        }
    }

    class FilterItem {
        String name;
        JCheckBox checkBox;
        JLabel label;

        FilterItem() {
        }
    }
}

