/*
  Copyright (C) 2011 Stefan Stäglich

  This file is part of pung.

  Pung is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Pung is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with pung.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "./Ball.h"
#include "./Pong.h"
#include "./PongObject.h"
#include "./Paddle.h"

// _____________________________________________________________________________
Ball::Ball(size_t id, Pong* pong)
{
  _id = id;
  _pong = pong;
  reset();
}

// _____________________________________________________________________________
void Ball::move()
{
  PongObject::move();

  // Touched barrier
  if (touchedBarrier())
    _yDiff = -_yDiff;

  // Touched paddle
  _pong->_leftPaddle->pushBall(_id);
  _pong->_rightPaddle->pushBall(_id);

  // Out of field?
  if (_xPos < 0)
  {
    // Add point for right paddle
    _pong->_rightPaddle->_score++;
    reset();
  }
  else
    if (_xPos > _pong->_wres)
    {
      // Add point for left paddle
      _pong->_leftPaddle->_score++;
      reset();
    }
}

// _____________________________________________________________________________
void Ball::inpulse(float modifyYDiff)
{
  // Modify the movement vector
  _xDiff = -_xDiff;
  _yDiff += modifyYDiff;

  // _yDiff should not be higher than _pong->_speed
  if (abs(_yDiff) >= _pong->_speed)
    _yDiff = (_yDiff >= 0) ? _pong->_speed : -_pong->_speed;
}

// _____________________________________________________________________________
void Ball::reset()
{
  _xSize = _pong->_hres / 40;
  _ySize = _pong->_hres / 22;
  _xPos = _pong->_wres / 2 - _xSize / 2;
  _yPos = _pong->_hres / 2 - _ySize / 2;

  // move vector
  unsigned int seed = time(NULL) + _id * 10000;
  int randomNumberX = ((rand_r(&seed) % 2) == 0) ? -1 : 1;
  int randomNumberY = (rand_r(&seed) % 100) - 50;
  _xDiff = _pong->_speed * randomNumberX;
  _yDiff = _pong->_speed / randomNumberY;
}
