/*
  Copyright (C) 2011 Stefan Stäglich

  This file is part of pung.

  Pung is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Pung is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with pung.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef PUNG_BALL_H_

#define PUNG_BALL_H_

#include <gtest/gtest.h>
#include "./PongObject.h"

// Forward declarations
class Paddle;
class Pong;

// A ball
class Ball : public PongObject
{
  friend class Paddle;
  friend class Pong;
 public:
  // Constructor. Set default values for the meber variables
  Ball(size_t id, Pong* pong);
  FRIEND_TEST(BallTest, constructor);

  // Move the ball
  void move();
  FRIEND_TEST(BallTest, move);

  // New direction vector because being touched of paddle
  // _xDiff = -_xDiff
  // _yDiff += modifyYDiff (_xDiff of paddle)
  void inpulse(float modifyYDiff);
  FRIEND_TEST(BallTest, inpulse);

  // Reset the ball
  void reset();
  FRIEND_TEST(BallTest, reset);

  // Tests of other classes
  FRIEND_TEST(PaddleTest, pushBall);
  FRIEND_TEST(PongTest, constructor);
  FRIEND_TEST(PongTest, reset);

 private:
  // The id of the ball
  size_t _id;
};

#endif  // PUNG_BALL_H_
