/*
  Copyright (C) 2011 Stefan Stäglich

  This file is part of pung.

  Pung is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Pung is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with pung.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef PUNG_PADDLE_H_

#define PUNG_PADDLE_H_

#include <SDL/SDL.h>
#include <gtest/gtest.h>
#include "./PongObject.h"

// Forward declarations
class Ball;
class Pong;

// A Paddle
class Paddle : public PongObject
{
  friend class Ball;
  friend class Pong;

 public:
  // Constructor. Set default values for the meber variables
  Paddle(Pong* pong, SDLKey moveUpKey, SDLKey moveDownKey);
  FRIEND_TEST(PaddleTest, constructor);

  // Push the ball (if you can)
  void pushBall(size_t ballId);
  FRIEND_TEST(PaddleTest, pushBall);

  // Move the paddle
  void move();
  FRIEND_TEST(PaddleTest, move);

  // Evaluates the SDL key event
  void keyEvent(const SDL_Event& event);

  // Draw the paddle with the score
  void draw();

  // Reset the paddle
  void reset();
  FRIEND_TEST(PaddleTest, reset);

  // Tests of other classes
  FRIEND_TEST(BallTest, move);
  FRIEND_TEST(PongTest, constructor);
  FRIEND_TEST(PongTest, parseCommandLineArguments);
  FRIEND_TEST(PongTest, reset);

 private:
  // The score
  int _score;

  // The key for moveing up
  SDLKey _moveUpKey;

  // The key fpr moving down
  SDLKey _moveDownKey;
};

#endif  // PUNG_PADDLE_H_
