/*
  Copyright (C) 2011 Stefan Stäglich

  This file is part of pung.

  Pung is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Pung is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with pung.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <gtest/gtest.h>
#include "./Paddle.h"
#include "./Pong.h"

// _____________________________________________________________________________
TEST(PaddleTest, constructor)
{
  Pong pong;
  Paddle* paddle = new Paddle(&pong, SDLK_w, SDLK_d);
  ASSERT_EQ(0, paddle->_xDiff);
  ASSERT_EQ(0, paddle->_yDiff);
  ASSERT_TRUE(SDLK_w == paddle->_moveUpKey);
  ASSERT_TRUE(SDLK_d == paddle->_moveDownKey);
  ASSERT_EQ(0, paddle->_score);
  ASSERT_EQ(0, paddle->_xPos);

  delete paddle;
}

// _____________________________________________________________________________
TEST(PaddleTest, pushBall)
{
  Pong pong;

  // Case 1: Ball in field
  pong._balls[0]->_xDiff = 7;
  pong._leftPaddle->pushBall(0);
  ASSERT_EQ(7, pong._balls[0]->_xDiff);

  // Case 2: Ball leftpaddle up
  pong._balls[0]->_xDiff = -3;
  pong._balls[0]->_xPos = pong._leftPaddle->_xPos + pong._leftPaddle->_xSize;
  pong._balls[0]->_yPos = pong._leftPaddle->_yPos;
  pong._leftPaddle->pushBall(0);
  ASSERT_EQ(3, pong._balls[0]->_xDiff);

  // Case 3: Ball leftpaddle down
  pong._balls[0]->_xDiff = -3;
  pong._balls[0]->_xPos = pong._leftPaddle->_xPos + pong._leftPaddle->_xSize;
  pong._balls[0]->_yPos = pong._leftPaddle->_yPos + pong._leftPaddle->_ySize;
  pong._leftPaddle->pushBall(0);
  ASSERT_EQ(3, pong._balls[0]->_xDiff);

  // Case 4: Ball rightpaddle up
  pong._balls[0]->_xDiff = -3;
  pong._balls[0]->_xPos = pong._leftPaddle->_xPos + pong._leftPaddle->_xSize;
  pong._balls[0]->_yPos = pong._leftPaddle->_yPos;
  pong._leftPaddle->pushBall(0);
  ASSERT_EQ(3, pong._balls[0]->_xDiff);

  // Case 5: Ball rightpaddle down
  pong._balls[0]->_xDiff = -3;
  pong._balls[0]->_xPos = pong._leftPaddle->_xPos + pong._leftPaddle->_xSize;
  pong._balls[0]->_yPos = pong._leftPaddle->_yPos + pong._leftPaddle->_ySize;
  pong._leftPaddle->pushBall(0);
  ASSERT_EQ(3, pong._balls[0]->_xDiff);
}

// _____________________________________________________________________________
TEST(PaddleTest, move)
{
  Pong pong;
  float oldYPos = pong._leftPaddle->_yPos;
  pong._leftPaddle->_ySize = 10;

  pong._leftPaddle->move();
  ASSERT_EQ(oldYPos, pong._leftPaddle->_yPos);

  pong._leftPaddle->_yDiff = -5;
  oldYPos -= 5;
  pong._leftPaddle->move();
  ASSERT_EQ(oldYPos, pong._leftPaddle->_yPos);

  pong._leftPaddle->_yPos = 0;
  pong._leftPaddle->move();
  ASSERT_EQ(0, pong._leftPaddle->_yDiff);
  ASSERT_EQ(1, pong._leftPaddle->_yPos);

  pong._leftPaddle->_yPos = pong._hres;
  pong._leftPaddle->move();
  ASSERT_EQ(0, pong._leftPaddle->_yDiff);
  ASSERT_EQ(pong._hres - 11, pong._leftPaddle->_yPos);
}

// _____________________________________________________________________________
TEST(PaddleTest, reset)
{
  Pong pong;
  float oldYPos = pong._leftPaddle->_yPos;
  pong._leftPaddle->_yPos = 2;

  pong._leftPaddle->reset();
  ASSERT_EQ(oldYPos, pong._leftPaddle->_yPos);
}
