/*
  Copyright (C) 2011 Stefan Stäglich

  This file is part of pung.

  Pung is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Pung is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with pung.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef PUNG_PONG_H_

#define PUNG_PONG_H_

#include <gtest/gtest.h>
#include <vector>
#include "./Ball.h"
#include "./Paddle.h"

// Main class of Pung
class Pong
{
  friend class Ball;
  friend class Paddle;
  friend class PongObject;

 public:
  // Constructor. Set default values for the meber variables
  Pong();
  FRIEND_TEST(PongTest, constructor);

  // Destructor. Reset the screen
  ~Pong();

  // Print usage
  static void printUsage();

  // Parse command line arguments. Returns false if an error occurred
  bool parseCommandLineArguments(int argc, char** argv);
  FRIEND_TEST(PongTest, parseCommandLineArguments);

  // Initialize SDL-Screen. Returns false if an error occurred
  bool initializeScreen();

  // Draws the output
  void draw();

  // Main function
  void playGame();
  FRIEND_TEST(PongTest, playGame);

  // Reset the game
  void reset();
  FRIEND_TEST(PongTest, reset);

  // Tests of the other classes
  FRIEND_TEST(BallTest, inpulse);
  FRIEND_TEST(BallTest, move);
  FRIEND_TEST(BallTest, reset);
  FRIEND_TEST(PaddleTest, pushBall);
  FRIEND_TEST(PaddleTest, move);
  FRIEND_TEST(PaddleTest, reset);
  FRIEND_TEST(PongObjectTest, touchedBarrier);

 private:
  // The screen-resolution
  int _hres;
  int _wres;

  // The speed variable of the game
  float _speed;

  // Max score
  int _maxScore;

  // Vector of the balls
  std::vector<Ball*> _balls;

  // The left paddle
  Paddle* _leftPaddle;

  // The right paddle
  Paddle* _rightPaddle;
};

#endif  // PUNG_PONG_H_
