/*
  Copyright (C) 2011 Stefan Stäglich

  This file is part of pung.

  Pung is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Pung is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with pung.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <GL/gl.h>
#include "./PongObject.h"
#include "./Pong.h"


// _____________________________________________________________________________
void PongObject::move()
{
  // Set the new position
  _xPos += _xDiff;
  _yPos += _yDiff;
}

// _____________________________________________________________________________
bool PongObject::touchedBarrier() const
{
  return (_yPos <= 0 || (_yPos + _ySize) >= _pong->_hres);
}

// _____________________________________________________________________________
void PongObject::draw() const
{
  // Draw the object with OpenGL
  glBegin(GL_QUADS);
  // Uni white
  glColor3f(1, 1, 1);
  glVertex2f(_xPos, _yPos);
  glVertex2f(_xPos, _yPos + _ySize);
  glVertex2f(_xPos + _xSize, _yPos + _ySize);
  glVertex2f(_xPos + _xSize, _yPos);
  glEnd();
}
