/*
  Copyright (C) 2011 Stefan Stäglich

  This file is part of pung.

  Pung is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Pung is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with pung.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef PUNG_PONGOBJECT_H_

#define PUNG_PONGOBJECT_H_

#include <gtest/gtest.h>

// Forward declarations
class Pong;

// The parent class of Ball and Paddle
class PongObject
{
  friend class Pong;

 public:
  // Move the object
  void move();
  FRIEND_TEST(PongObjectTest, move);

  // The PongObject has touched the barrier?
  bool touchedBarrier() const;
  FRIEND_TEST(PongObjectTest, touchedBarrier);

  // Draw it
  void draw() const;

 protected:
  // The current position
  float _xPos;
  float _yPos;

  // The size
  float _xSize;
  float _ySize;

  // The current direction vector
  float _xDiff;
  float _yDiff;

  // The main pong object
  Pong* _pong;
};

#endif  // PUNG_PONGOBJECT_H_
