/*
  Copyright (C) 2011 Stefan Stäglich

  This file is part of pung.

  Pung is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Pung is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with pung.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <gtest/gtest.h>
#include "./PongObject.h"
#include "./Pong.h"

// _____________________________________________________________________________
TEST(PongObjectTest, move)
{
  PongObject POtest;
  POtest._xPos = 3;
  POtest._yPos = 4;
  POtest._xDiff = 9;
  POtest._yDiff = 8;

  POtest.move();

  ASSERT_EQ(12, POtest._xPos);
  ASSERT_EQ(12, POtest._yPos);
  ASSERT_EQ(9, POtest._xDiff);
  ASSERT_EQ(8, POtest._yDiff);
}

// _____________________________________________________________________________
TEST(PongObjectTest, touchedBarrier)
{
  Pong pong;
  PongObject POtest;
  POtest._pong = &pong;
  POtest._xSize = 3;
  POtest._ySize = 3;

  POtest._xPos = 3;
  POtest._yPos = 4;
  ASSERT_FALSE(POtest.touchedBarrier());
  POtest._xPos = -1;
  ASSERT_FALSE(POtest.touchedBarrier());
  POtest._yPos = 0;
  ASSERT_TRUE(POtest.touchedBarrier());
  POtest._yPos = 1;
  ASSERT_FALSE(POtest.touchedBarrier());
  POtest._xPos = 900;
  ASSERT_FALSE(POtest.touchedBarrier());
  POtest._yPos = 0;
  ASSERT_TRUE(POtest.touchedBarrier());
  POtest._xPos = 600;
  ASSERT_TRUE(POtest.touchedBarrier());
  POtest._yPos = pong._hres;
  ASSERT_TRUE(POtest.touchedBarrier());
  POtest._yPos = pong._hres - 4;
  ASSERT_FALSE(POtest.touchedBarrier());
}
