/*
  Copyright (C) 2011 Stefan Stäglich

  This file is part of pung.

  Pung is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Pung is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with pung.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <gtest/gtest.h>
#include "./Pong.h"

// _____________________________________________________________________________
TEST(PongTest, constructor)
{
  Pong pong;

  ASSERT_EQ(640, pong._wres);
  ASSERT_EQ(480, pong._hres);
  ASSERT_EQ(0, pong._speed);
  ASSERT_EQ(3, pong._maxScore);

  ASSERT_EQ(0, pong._balls[0]->_id);

  ASSERT_TRUE(pong._leftPaddle->_moveUpKey == SDLK_w);
  ASSERT_TRUE(pong._leftPaddle->_moveDownKey == SDLK_s);
  ASSERT_TRUE(pong._rightPaddle->_moveUpKey == SDLK_UP);
  ASSERT_TRUE(pong._rightPaddle->_moveDownKey == SDLK_DOWN);
}

// _____________________________________________________________________________
TEST(PongTest, parseCommandLineArguments)
{
  // Invalid call (non-existing option)
  {
    Pong pongTest;
    char* argv[2] = {const_cast<char*>("./PongMain"), const_cast<char*>("-x")};
    ASSERT_FALSE(pongTest.parseCommandLineArguments(2, argv));
  }

  // Valid call
  {
    Pong pongTest;
    char* argv[7] = {const_cast<char*>("./PongMain"),
      const_cast<char*>("--width=300"), const_cast<char*>("--height=300"),
      const_cast<char*>("--paddle-size=300"), const_cast<char*>("--speed=300"),
      const_cast<char*>("--max-score=30"),
      const_cast<char*>("--number-of-balls=3")};

    ASSERT_TRUE(pongTest.parseCommandLineArguments(7, argv));
    ASSERT_EQ(300, pongTest._wres);
    ASSERT_EQ(300, pongTest._hres);
    ASSERT_EQ(300, pongTest._leftPaddle->_ySize);
    ASSERT_EQ(300, pongTest._rightPaddle->_ySize);
    ASSERT_EQ(300, pongTest._speed);
    ASSERT_EQ(30, pongTest._maxScore);
    ASSERT_EQ(3, pongTest._balls.size());
  }
}

// _____________________________________________________________________________
TEST(PongTest, reset)
{
  Pong pong;

  pong._speed = 0;
  float oldBallPosX = pong._balls[0]->_xPos;
  pong._balls[0]->_xPos = 1;
  float oldBallPosY = pong._balls[0]->_yPos;
  pong._balls[0]->_yPos = 1;
  float oldBallSizeX = pong._balls[0]->_xSize;
  pong._balls[0]->_xSize = 100;
  float oldBallSizeY = pong._balls[0]->_ySize;
  pong._balls[0]->_xSize = 100;
  float oldPaddlePosY = pong._leftPaddle->_yPos;
  pong._leftPaddle->_yPos = 5;
  pong._rightPaddle->_yPos = 9;
  pong.reset();
  ASSERT_EQ(pong._wres/100, pong._speed);
  ASSERT_EQ(oldBallPosX, pong._balls[0]->_xPos);
  ASSERT_EQ(oldBallPosY, pong._balls[0]->_yPos);
  ASSERT_EQ(oldBallSizeX, pong._balls[0]->_xSize);
  ASSERT_EQ(oldBallSizeY, pong._balls[0]->_ySize);
  ASSERT_EQ(oldPaddlePosY, pong._leftPaddle->_yPos);
  ASSERT_EQ(oldPaddlePosY, pong._rightPaddle->_yPos);

  pong._speed = 77;
  pong.reset();
  ASSERT_EQ(77, pong._speed);
}
