from gtk import * 
import gtk.glade
import gobject

from parser import *
from syntacticengine import *

from config import GLADE_FILE_PATH

class SchedulerListStore(gtk.ListStore):
    def __init__(self,activeColor,inactiveColor):
        # Call parent constructor with column defintions
        gtk.ListStore.__init__(self,
                               gobject.TYPE_PYOBJECT,
                               gobject.TYPE_STRING,
                               gobject.TYPE_STRING,
                               gobject.TYPE_STRING)
        
        # store active and inactive colors as internal fields
        self.activeColor = activeColor
        self.inactiveColor = inactiveColor

        # create an array of parser objects
        self.parserList = []
        self.parserList.append(CronEntryParser())
        self.parserList.append(AtEntryParser())
        self.parserList.append(PyAtCronEntryParser())

        # for each of them
        for parser in self.parserList:
            # load the system task list
            parser.loadSystemEntryList()
            # and add each entry to ourself (ListStore)
            for entry in parser.getEntryList():
                self.addScheduler(entry)

        # set the 'modified' field to False. This value have to be set
        # to True whenever a change is done on some objects of the
        # ListStore. This can be used to know if saving is needed
        # before exiting
        self.modified = False
        
        return

    def addScheduler(self,scheduler):
        # Start a syntactic engine
        syntactic = SyntacticEngine(scheduler)
        # get an GtkIter object on a new row at top of list
        iter = self.append(None)
        # set values to this new row
        if(scheduler.isActive()):
            color = self.activeColor
        else:
            color = self.inactiveColor
        self.set(iter,0,scheduler,
                 1,syntactic.getSchedulerName(),
                 2,syntactic.getNextRunString(),
                 3,color)
        # connect to the Scheduler "scheduler-changed" signal and
        scheduler.connect('scheduler-changed',self.on_scheduler_changed,
                          (iter,syntactic))
        # set the modified status to True
        self.modified = True

    def delScheduler (self,iter):
        self.remove (iter)
        self.modified = True

    def saveSchedulers(self):
        # clear entries of our parser objects
        for parser in self.parserList:
            parser.clearEntryList()
        # Now for each entry in ourself run the __addSchedulerToParser method
        self.foreach(self.__addSchedulerToParser,None)
        
        # and finally save parser entries to the system
        for parser in self.parserList:
            parser.saveEntryList()

        # set our modified status to False (every changes are now saved)
        self.modified = False
        
        return

    def isModified(self):
        return self.modified

    def __addSchedulerToParser(self, model, path, iter, user_data):
        # retrieve Scheduler object from model
        scheduler = model.get_value(iter,0)

        # check if Scheduler is active
        if (scheduler.isActive()):
            # check if scheduler is recurrent
            if(scheduler.isRecurrent()):
                # store it in CronParser
                self.parserList[0].addEntry(scheduler)
            else:
                # Store it in AtParser
                self.parserList[1].addEntry(scheduler)
        else:
            # not active, store scheduler in the PyAtCronParser
            self.parserList[2].addEntry(scheduler)
        return

    # callback used when something is updated in a Scheduler
    def on_scheduler_changed(self,obj,data):
        # retrieve usefull data from parameter
        iter, syntactic = data

        # update ListStore values
        self.set(iter,
                 1,syntactic.getSchedulerName(),
                 2,syntactic.getNextRunString()
                 )

        # set the 'modified' field to True
        self.modified = True
        

class SchedulerEditor:
    def __init__(self, scheduler):
        self.scheduler = scheduler

        self.wtree = gtk.glade.XML(GLADE_FILE_PATH + '/task_properties.glade')
	# You need to create this dictionary in order to get the 
        # bound methods that you can autoconnect with.
        # "I know it is not perfect, but it should do what you want."
	dict = {}
	for key in dir(self.__class__):
	    dict[key] = getattr(self, key)
	self.wtree.signal_autoconnect(dict)

        # retrieve notebook from widget tree
        notebook = self.wtree.get_widget('notebook')

        # insert Task Editor widgets to first notebook page
        scheduler.getTask().show()
        notebook.insert_page(scheduler.getTask(),
                             gtk.Label("Task"),0)

        
        # insert Scheduler editor widgets to second notebook page
        scheduler.show()
        notebook.insert_page(scheduler,
                             gtk.Label("Schedule"),1)
        
        # set the Task editor page active
        notebook.set_current_page(0)

        # show notebook
        notebook.show()
        
        # Connect to the 'changed' signal of the Task
        scheduler.getTask().connect('task-changed',self.on_task_changed,
                                    scheduler)
        scheduler.connect('scheduler-changed',self.on_scheduler_changed)

    def show(self, parent):
        win = self.wtree.get_widget("taskProperties")
        # Center the window on the parent.
        win.set_transient_for (parent)
        win.set_position (gtk.WIN_POS_CENTER_ON_PARENT)
        win.show()

    def on_task_changed(self,obj,scheduler):
        scheduler.emit('scheduler-changed')
        
    def on_scheduler_changed(self,obj):
        print "SchedulerEditor::on_scheduler_changed: NOT IMPLEMENTED"

    def on_taskProperties_delete_event(self, obj, event):
        self.wtree.get_widget('taskProperties').destroy()

    def on_taskProperties_destroy_event(self, obj, event):
        self.wtree.get_widget('taskProperties').destroy()

    def on_closeButton_clicked(self,*args):
        self.wtree.get_widget('taskProperties').destroy()


