import popen2, re, string, pickle, os.path, os

from errors import *
from scheduler import Scheduler
from task import TaskFactory

from config import CONFIG_FOLDER
from config import PYATCRON_ENTRY_FILE

# base class for the three different job scheduler parser
class EntryParser:
    def __init__(self):
        self.entries = []
        return

    # Add a Schedule object to the internal list
    def addEntry(self,schedule):
        self.entries.append(schedule)
        return

    # to be overridden by child classes
    def loadSystemEntryList(self):
        return

    # clear entry list
    def clearEntryList(self):
        self.entries = []

    # Get the Schedule object list
    def getEntryList(self):
        return self.entries

    # Save the Schedule object list to system - to be overridden
    def saveEntryList(self):
        print "WARNING - saveEntryList method must be overridden"
        return

# Cron system job parser
class CronEntryParser(EntryParser):
    # Some dictionnaries used by the CronEntryParser class
    nameDict = {'jan': 1,'feb': 2,'mar': 3,'apr': 4,'may': 5,'jun': 6,
                'jul': 7,'aug': 8,'sep': 9,'oct': 10,'nov': 11,'dec': 12,
                'mon': 1,'tue': 2,'wed': 3,'thu': 4,'fri': 5,'sat': 6,
                'sun': 7 }

    def loadSystemEntryList(self):
        try:
            self.__parseCronTab()
        except CronParserError, e:
            print e.getMessage()
        return

    # this method should save the Scheduler objects into the Cron system
    def saveEntryList(self):
        lines = []
        for scheduler in self.entries:
            cronline = ""
            elem = scheduler.getAttributes()
            cronline=cronline + self.__convertArrayToField(elem[0],0,59)+" "
            cronline=cronline + self.__convertArrayToField(elem[1],0,23)+" "
            cronline=cronline + self.__convertArrayToField(elem[2],1,31)+" "
            cronline=cronline + self.__convertArrayToField(elem[3],1,12)+" "
            cronline=cronline + self.__convertArrayToField(elem[4],1,7)+" "
            
            lines.append(cronline + elem[6].getCmdLine() + "\n")

        fromchild, tochild = popen2.popen2("crontab")
        for line in lines:
            tochild.write(line)
        tochild.close()
            

    def __convertArrayToField(self,array,minValue,maxValue):
        if(array == range(minValue,maxValue + 1)):
            return "*"
        else:
            result = ""
            for key in array:
                result = result + str(key) + ","
            return string.rstrip(result,",")

    # Parse crontab and add jobs as Schedule objects
    def __parseCronTab(self):
        fromchild, tochild = popen2.popen2("crontab -l")
        line = fromchild.readline()
        i = 1
        while line:
            # remove leading spaces from line
            line = string.lstrip(line,' ')
            #remove trailing \n
            line = string.rstrip(line,'\n')
            # ignore empty lines, comment lines and cron env config strings
            if ((not re.compile(r"(^#)|(.*=.*)").match(line))
                and (len(line) > 0)):
                # At this point, we should have only valid cron command
                tmpfields = string.split(line,' ',6);
                if (len(tmpfields) < 6):
                    raise CronParserError("fields missing in cron command")
                #list = re.findall("\S+",line)[0:5]
                tmpfields[0] = self.__convertFieldToArray(tmpfields[0],0,59)
                tmpfields[1] = self.__convertFieldToArray(tmpfields[1],0,23)
                tmpfields[2] = self.__convertFieldToArray(tmpfields[2],1,31)
                tmpfields[3] = self.__convertFieldToArray(tmpfields[3],1,12)
                tmpfields[4] = self.__convertFieldToArray(tmpfields[4],0,7)
                for i in range(len(tmpfields[4])):
                    if (tmpfields[4][i] == 0):
                        tmpfields[4][i] = 7

                fields=[[],[],[],[],[]]
                for i in range(5):
                    tmpfields[i].sort()
                    last=-1
                    for j in range(len(tmpfields[i])):
                        if((tmpfields[i][j]!=last) or j==0):
                            fields[i].append(tmpfields[i][j])
                            last=tmpfields[i][j]

                command = string.join(re.findall("\S+",line)[5:]," ")
                factory = TaskFactory()
                task = factory.getTask(command)

                
                temp = fields[0:5]
                temp.append([])
                self.addEntry(Scheduler(temp,task,Scheduler.CRON))

            line = fromchild.readline()
        return

    def __convertFieldToArray(self,field,minValue,maxValue):
        # check if the field contains alphabetic values
        if re.compile(r"[a-zA-Z]+").match(field):
            # verify that there is only three alpha characters
            if not re.compile(r"^[a-zA-Z]{3}$").match(field):
                raise CronParserError("Non matching alpha chars in field")
            # return one element array containing corresponding number
            return [self.nameDict[field]]

        # check if we have a '*' character
        if(string.find(field,"*") != -1):
            # is there an incremental step value?
            if(string.find(field,"*/") != -1):
                # build array with according step
                step = int(field[2:])
                a = []
                for n in range(minValue,maxValue+1):
                    if (n - minValue)  % step == 0:
                        a.append(n)
                return a
            else:
                #simply return array with range from min to max
                return range(minValue,maxValue+1)
        
        # if we've reached this step, then we have to deal list of int values
        a = []
        for item in string.split(field,','):
            # check if we have a range value
            if(string.find(item,'-') != -1):
                step = 1
                interval = []
                # check if there is an incremental step and set step variable
                if(string.find(item,'/') != -1):
                    temp = string.split(item,'/')
                    step = int(temp[1])
                    interval = string.split(temp[0],'-');
                else:
                    interval = string.split(item,'-');
                #fill array with this range
                for y in range(int(interval[0]),int(interval[1])+1):
                    if(y - int(interval[0])) % step == 0:
                        a.append(y)
            else:
                # we should have an integer value
                a.append(int(item))
        return a # hmm, a is not a good name for a var, must be changed ;-)

class AtEntryParser(EntryParser):
    
    def loadSystemEntryList(self):
        self.__parseAtJobs()

    def saveEntryList(self):
        print "AtEntryParser::saveEntryList: NOT IMPLEMENTED"        
        for scheduler in self.entries:
            print "     Processing Active At scheduler: TO BE DONE"

    def __parseAtJobs(self):
        print "AtEntryParser::__parseAtJob: NOT IMPLEMENTED"
        return


class PyAtCronEntryParser(EntryParser):

    def loadSystemEntryList(self):
        self.__parsePyatcronRCFile()
    
    def saveEntryList(self):
        # overwrite data entry file
        file = open(CONFIG_FOLDER + PYATCRON_ENTRY_FILE,'w')
        for scheduler in self.entries:
            attributes = scheduler.getAttributes()[0:6]
            attributes.append(scheduler.getAttributes()[6].getCmdLine())
            pickle.dump(attributes,file)
        # close file
        file.close()

    def __parsePyatcronRCFile(self):
        # simply return if inactive entry data file does not exist
        if(os.path.isfile(CONFIG_FOLDER + PYATCRON_ENTRY_FILE) != True):
            return
        # open entry data file in read-only mode
        file = open(CONFIG_FOLDER + PYATCRON_ENTRY_FILE,'r')
        # and load data
        try:
            attributes = pickle.load(file)
            while True:
                factory = TaskFactory()
                task = factory.getTask(attributes[6])
                temp = attributes[0:6]
                
                self.addEntry(Scheduler(temp,task,
                                        recurrent = Scheduler.CRON,
                                        active = False))
                
                attributes = pickle.load(file)
        except EOFError, e:
            print e
        # do not forget to close file, it's much cleaner ;-)
        file.close()
        return

