import gtk
import gobject

from config import GLADE_FILE_PATH


class Scheduler(gtk.VBox):
    """This class will be used to create schedules for either
    the At or Cron programs"""

    # Type of schedulers
    UNKNOWN = 0
    CRON    = 1
    AT      = 3
    

    def __init__(self,timerList,task,recurrent = True, active = True):
        # call parent constructor
        gtk.VBox.__init__(self)
        
        # Initialize schedule type attributes
        if(recurrent):
            self.type = Scheduler.CRON
        else:
            self.type = Scheduler.AT

        # set name and description to default values
        self.schedulerDescription = ""
        self.schedulerName = ""

        # check if valueList has the 6 needed arrays
        if len(timerList) == 6:
            # intialize the different dictionnaries for Selector objects
            minuteDict   = self.__listToSelectorDict(range(0,60))
            hourDict     = self.__listToSelectorDict(range(0,24))
            monthdayDict = self.__listToSelectorDict(range(1,32))
            monthDict    = self.__listToSelectorDict(range(1,13))
            # weekdayDict is a special one
            weekdayDict = {}
            weekdayDict[0] = "Sunday"
            weekdayDict[1] = "Monday"
            weekdayDict[2] = "Tuesday"
            weekdayDict[3] = "Wednesday"
            weekdayDict[4] = "Thursday"
            weekdayDict[5] = "Friday"
            weekdayDict[6] = "Saturday"
            
            # Initialize the time/date attributes
            self.minute   = self.__initSelector(minuteDict,"Minute",
                                                timerList[0])
            self.hour     = self.__initSelector(hourDict,"Hour",
                                                timerList[1])
            self.monthday = self.__initSelector(monthdayDict,"Month day",
                                                timerList[2])
            self.month    = self.__initSelector(monthDict,"Month",
                                                timerList[3])
            self.weekday  = self.__initSelector(weekdayDict,"Weekday",
                                                timerList[4])
            # year attribute is not handled with a selector. Not really smart
            # coding, but it works.
            self.year     = timerList[5]
            
        #if not
        else:
            # raise an exception
            raise Exception
            
        # set Task object
        self.task    = task
        
        # Set the active status
        self.active = active

        # prepare schedule parameters editing widgets
        self.__initWidget()

        return
    
    def __str__(self):
        return str(self.task)

    # create a dictionnary with a list of values
    def __listToSelectorDict(self,list):
        dict = {}
        for key in list:
            dict[key] = str(key)
        return dict

    # intialize a SimpleValueSelector
    def __initSelector(self,dict,title,selected):
        # instanciate a selector
        selector = SimpleValueSelector(dict,title)
        # set the selected values
        selector.setSelected(selected)
        # and return the selector
        return selector

    # This methods initialize widgets needed to edit schedule parameters
    def __initWidget(self):

        # Non recurrent task widgets - not defined as long as the AT
        # scheduling system is not supported
        nonRecurrentPane = gtk.Table(2,2)
        #nonRecurrent.attach(gtk.Label("Select time"),0,1,0,1)
        #timeCombo = gtk.Combo()
        #nonRecurrent.attach(gtk.Label("1"),0,1,0,1)
        #nonRecurrent.attach(timeCombo,1,2,0,1)
        #calendar = gtk.Calendar()
        #nonRecurrent.attach(gtk.Label("Select date"),0,1,1,2)
        #nonRecurrent.attach(gtk.Calendar(),1,2,1,2)
        nonRecurrentPane.attach(gtk.Label("NOT AVAILABLE"),0,2,0,2)
        nonRecurrentPane.show_all()
        self.pack_start(nonRecurrentPane)

        # Recurrent task widgets
        recurrentPane = gtk.VBox()
        hbox = gtk.HBox(spacing=10, homogeneous = True)
        
        hbox.pack_start(self.minute)
        hbox.pack_start(self.hour)
        hbox.pack_start(self.monthday)
        hbox.pack_start(self.month)
        hbox.pack_start(self.weekday)
        hbox.show_all()

        recurrentPane.pack_start(gtk.Label("Select schedule values"))
        recurrentPane.pack_start(hbox)
        self.pack_start(recurrentPane)
        
        # Recurent button deactivated as long as the AT scheduling system
        # is not supported
        checkbox = gtk.CheckButton(label = "Recurrent task")
        checkbox.set_active(self.isRecurrent())
        #checkbox.show()
        checkbox.connect("toggled",self.on_recurrent_checkbutton_toggled,
                         (recurrentPane,nonRecurrentPane))
        checkbox.toggled()
        #self.pack_start(checkbox)

        # Does not work ???
        #calendar.connect("day_selected",self.on_calendar_day_selected)

        
        return self

    ########################################################
    #                                                      #
    #        CALLBACK FUNCTIONS                            #
    #                                                      #
    ########################################################

    def on_recurrent_checkbutton_toggled(self,obj,data):
        recurrent,nonRecurrent = data
        if(obj.get_active()):
            self.setRecurrency(True)
            recurrent.show()
            nonRecurrent.hide()
        else:
            self.setRecurrency(False)
            recurrent.hide()
            nonRecurrent.show()

    ########################################################
    #                                                      #
    #        PUBLIC METHODS                                #
    #                                                      #
    ########################################################

    # This method is used to set type of a task. return new recurrence value
    def setRecurrency(self,status):
        # must be adapted to change dates and times values depending on type
        if(status):
            self.type = Scheduler.CRON
        else:
            self.type = Scheduler.AT

        # emit the "scheduler-changed" signal
        self.emit("scheduler-changed")

        return status

    # set the active status of the Scheduler. returns new active value
    def setActive(self,value):
        if (value):
            self.active = True
            print "Scheduler::setActive: active status set to True"
        else:
            self.active = False
            print "Scheduler::setActive: active status set to False"

        # emit the "scheduler-changed" signal
        self.emit("scheduler-changed")

        return self.active

    def isRecurrent(self):
        return (self.type == Scheduler.CRON)
    
    def isActive(self):
        return(self.active)


    def getAttributes(self):
        return [
            self.minute.getSelected(),
            self.hour.getSelected(),
            self.monthday.getSelected(),
            self.month.getSelected(),
            self.weekday.getSelected(),
            self.year,
            self.task
            ]


    # returns widgets used to set Task parameters
    def getTask(self):
        return self.task

    # method mainly used for debugging purpose. not to be used in production
    def prettyPrint(self):
        print "Name        : ",self.schedulerName
        print "Type        : ",self.type
        print "Active      : ",self.active
        print "Task        : ",self.task
        print "minute      : ",self.minute
        print "hour        : ",self.hour
        print "day of month: ",self.monthday
        print "month       : ",self.month
        print "day of week : ",self.weekday
        print "year        : ",self.year
        print ""

# Add a new signal to our Scheduler object
gobject.signal_new("scheduler-changed", Scheduler,
                   gobject.SIGNAL_RUN_LAST,
                   gobject.TYPE_NONE,
                   ())

        

class SimpleValueSelector(gtk.VBox):
    def __init__(self,dict,title = ""):
        gtk.VBox.__init__(self)

        # create a ListStore as model with two columns
        model = gtk.ListStore(gobject.TYPE_INT,gobject.TYPE_STRING)
        # create a TreeView with this model
        self.tree = gtk.TreeView(model)
        # create a CellRenderer
        renderer = gtk.CellRendererText()
        # and a column with this renderer
        column = gtk.TreeViewColumn("Value",renderer,text=1)
        # set column title text and make it clickable
        column.set_title(title)
        column.set_clickable(True)
        # and connect column clicked signal
        column.connect("clicked",self.__on_column_clicked,None)
        # append the TreeViewColumn to our internal TreeView
        self.tree.append_column(column)
        # Set selection mode to MULTIPLE
        self.tree.get_selection().set_mode(gtk.SELECTION_MULTIPLE)
        # And add the TreeView to a ScrolledWindow
        scrolled = gtk.ScrolledWindow()
        scrolled.add(self.tree)
        # set policy for ScrolledView adjustments
        scrolled.set_policy(gtk.POLICY_NEVER,gtk.POLICY_AUTOMATIC)
        # and its minimum height
        scrolled.set_size_request(-1,150)
        # and pack the ScrolledWindow to ourself
        self.pack_start(scrolled)

        # Fill in the ListStore values passed as parameter
        for key in dict:
            iter = model.append(None)
            model.set_value(iter,0,key)
            model.set_value(iter,1,dict[key])


        # and finally show ourself
        self.show_all()
        return

    def __on_column_clicked(self,obj,data):
        # select all entries on header click
        self.tree.get_selection().select_all()

    def getSelected(self):
        selected = []
        selection = self.tree.get_selection()
        selection.selected_foreach(lambda model, path, iter, sel =
                                   selected:
                                   sel.append(model.get_value(iter,0)))
        return selected

    def setSelected(self,list):
        model = self.tree.get_model()
        iter = model.get_iter_first()
        selection = self.tree.get_selection()
        while iter != None:
            if model.get_value(iter,0) in list:
                selection.select_iter(iter)
            iter = model.iter_next(iter)
        return
