import gtk
import gtk.glade

from config import GLADE_FILE_PATH

# The new task assistant's class.
class About:
    def __init__ (self, parent):

        # We load the widgets and the callbacks from the glade file.
        self.widgetTree = gtk.glade.XML (GLADE_FILE_PATH +
                         "/about.glade")

    	dict = {}
    	for key in dir(self.__class__):
    	    dict[key] = getattr(self, key)
        self.widgetTree.signal_autoconnect (dict)

        # It's the base widget.
        self.win = self.widgetTree.get_widget ("about")

        # If a parent is specified, center the window on it.
        if parent:
            self.win.set_transient_for (parent)
            self.win.set_position (gtk.WIN_POS_CENTER_ON_PARENT)

	# Set the version label to the actual Py@Cron release
	label = self.widgetTree.get_widget('versionLabel')
	label.set_text("Release " + "@PKGVERSION@ (@PKGVERSIONNAME@)")

        # Displays the about dialog.
        self.win.show ()

    def on_about_delete_event (self, obj, event):
        self.quit ()

    def on_close_button_clicked (self, obj):
        self.quit ()

    # Unreferences the main window's widgets.
    def quit (self):
        self.win.destroy ()
