#Parent class for PyAtCron specific exception
class PyAtCronError(Exception):
    def __init__(self):
        self.message = "Unknown PyAtCron error occured"

    def getMessage(self):
        return self.message

# Entry Parser Exceptions
class CronParserError(PyAtCronError):
    def __init__(self,message):
        self.message = "Error while parsing 'crontab -l' output: " + message

# ScheduleList Exceptions
class ScheduleListError(PyAtCronError):
    def __init__(self,message):
        self.message = "Error in ScheduleList: " + message
