#!/usr/bin/env pyformex
##
##  This file is part of pyFormex 0.8.1 Release Wed Dec  9 11:27:53 2009
##  pyFormex is a tool for generating, manipulating and transforming 3D
##  geometrical models by sequences of mathematical operations.
##  Homepage: http://pyformex.org   (http://pyformex.berlios.de)
##  Copyright (C) Benedict Verhegghe (benedict.verhegghe@ugent.be) 
##  Distributed under the GNU General Public License version 3 or later.
##
##
##  This program is free software: you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##
##  You should have received a copy of the GNU General Public License
##  along with this program.  If not, see http://www.gnu.org/licenses/.
##

from coords import *

def coords_transformation(func):
    """Perform a transformation on the .coords attribute of the object

    """
    def newf(self,*args,**kargs):
        repl = getattr(Coords,func.__name__)
        self.coords = repl(self.coords,*args,**kargs)
        return self
        newf.__name__ = func.__name__
        newf.__doc__ = repl.__doc__
    return newf


class Geometry(object):

    def transform(self,funcname,*args,**kargs):
        """Transform the coordinates of the object using the function
        func(*args,**kargs), where func is a transformation method of the
        Coords class.
        """
        func = getattr(self.coords,funcname)
        self.coords = func(self.coords,*args,**kargs)

    def __str__(self):
        return self.coords.__str__()

 
    @coords_transformation
    def scale(self,*args,**kargs):
        pass
    @coords_transformation
    def translate(self,*args,**kargs):
        pass


if __name__ == "draw":

    X = Coords([[0.,0.,0.],[1.,1.,1.]])

    G = Geometry()
    G.coords = X

    print(G.coords)
    
    print(G.scale(2).coords)
    print(G.scale(4))
