#
##
##  This file is part of pyFormex 2.0  (Mon Sep 14 12:29:05 CEST 2020)
##  pyFormex is a tool for generating, manipulating and transforming 3D
##  geometrical models by sequences of mathematical operations.
##  Home page: http://pyformex.org
##  Project page:  http://savannah.nongnu.org/projects/pyformex/
##  Copyright 2004-2020 (C) Benedict Verhegghe (benedict.verhegghe@ugent.be)
##  Distributed under the GNU General Public License version 3 or later.
##
##  This program is free software: you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##
##  You should have received a copy of the GNU General Public License
##  along with this program.  If not, see http://www.gnu.org/licenses/.
##
"""vtk_light

This module initializes the vtk_light package, a replacement for python-vtk:
- it detects the standard python-vtk installation;
- it changes the sys.path to make python-vtk submodules being loadable
  without having to import the whole vtk.
"""

import os
import sys
from pyformex import utils

# Find the standard python-vtk package
fn = utils.findModuleSource('vtk')
if not fn:
    raise ImportError("Could not find python-vtk.")

sys.path.insert(1,os.path.dirname(fn))
from vtkCommonCore import VTK_VERSION

# End
