#
##
##  This file is part of pyFormex 2.4  (Thu Feb 25 13:39:20 CET 2021)
##  pyFormex is a tool for generating, manipulating and transforming 3D
##  geometrical models by sequences of mathematical operations.
##  Home page: http://pyformex.org
##  Project page:  http://savannah.nongnu.org/projects/pyformex/
##  Copyright 2004-2020 (C) Benedict Verhegghe (benedict.verhegghe@ugent.be)
##  Distributed under the GNU General Public License version 3 or later.
##
##  This program is free software: you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##
##  You should have received a copy of the GNU General Public License
##  along with this program.  If not, see http://www.gnu.org/licenses/.
##
"""DrawText3D

This example illustrates the drawing of a text in full 3D. The text is
displayed on a Formex grid and can be manipulated and transformed by
the usual pyFormex methods.
"""

_status = 'checked'
_level = 'normal'
_topics = ['text']
_techniques = ['dialog', 'font', 'text']

from pyformex.gui.draw import *
from pyformex.gui import QtGui
from pyformex.opengl.textext import FontTexture

def sameLength(text):
    """Make sure all strings hat the same length

    in: list of str
    out: list of str with all same length
    """
    maxlen = max([len(s) for s in text])
    return [s + ' '*(maxlen-len(s)) for s in text[::-1]]


def draw3DText(text, font=None, ftsize=10, color=None, texmode=2, ontop=True):
    if isinstance(text, str):
        text = text.split('\n')
    text = sameLength(text)
    nrows = len(text)
    ncols = len(text[0])
    text = ''.join(text)
    print(text, ncols, nrows)
    G = Formex('4:0123').replicm((ncols,nrows))
    if font is None:
        font = 'NotoSansMono-Condensed.3x32.png'
    ft = FontTexture(font, 24)
    tc = ft.texCoords(text)
    if color is None:
        color = pf.canvas.settings.bgcolor
    draw(G, color=color, texture=ft, texcoords=tc, texmode=texmode, ontop=ontop)
    zoomOut(2)


def run():
    clear()
    flat()
    fonts = utils.listMonoFonts()
    res = askItems([
        _I('text', 'pyFormex\nrules\nthe world!', itemtype='text'),
        _I('font', choices=fonts),
        ])
    if res:
        print(res)
        draw3DText(**res)

if __name__ == '__draw__':
    run()
# End
