#
##
##  This file is part of pyFormex 2.4  (Thu Feb 25 13:39:20 CET 2021)
##  pyFormex is a tool for generating, manipulating and transforming 3D
##  geometrical models by sequences of mathematical operations.
##  Home page: http://pyformex.org
##  Project page:  http://savannah.nongnu.org/projects/pyformex/
##  Copyright 2004-2020 (C) Benedict Verhegghe (benedict.verhegghe@ugent.be)
##  Distributed under the GNU General Public License version 3 or later.
##
##  This program is free software: you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##
##  You should have received a copy of the GNU General Public License
##  along with this program.  If not, see http://www.gnu.org/licenses/.
##
"""Layers

Subdivide a cylindrical mesh in different (radial) layers.
To every layer a different property is assigned.
"""

_status = 'checked'
_level = 'normal'
_topics = ['surface', 'cylinder']
_techniques = ['surface', 'subdivide', 'frontwalk', 'layers', 'partitioning']

from pyformex.gui.draw import *
from pyformex.simple import cylinder

def run():
    clear()
    cyl = cylinder(L=8., D=2., nt=36, nl=20, diag='').centered().toMesh()
    cyl = cyl.connect(cyl.scale([1.2, 1.2, 1]))
    cyl = cyl.subdivide(1, 1, [0, 0.1, 0.3, 0.6, 1])
    # drawing the border mesh for hex Meshes gives nicer graphics
    draw(cyl.getBorderMesh(), color=red)
    pause()
    clear()

    cylbrd = cyl.getBorderMesh()
    cyledgs = cyl.getFreeEntitiesMesh(level=1)
    pcyl = cylbrd.partitionByCurve(cyledgs)

    cylbrd = cylbrd.setProp(pcyl)

    innds = cyl.matchCoords(cylbrd.selectProp(1, compact=True))
    inelems = cyl.connectedTo(innds)

    play = cyl.frontWalk(startat=inelems)
    cyl = cyl.setProp(play)
    draw(cyl.getBorderMesh(), color='prop')


if __name__ == '__draw__':
    run()
# End
